/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.messagedigest;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.charset.CharsetManager;
import com.helger.commons.messagedigest.IMessageDigestGenerator;
import com.helger.commons.messagedigest.MessageDigestGeneratorHelper;
import java.nio.charset.Charset;
import javax.annotation.Nonnull;

public abstract class AbstractMessageDigestGenerator
implements IMessageDigestGenerator {
    @Override
    @Nonnull
    public final IMessageDigestGenerator update(@Nonnull String string, @Nonnull Charset charset) {
        ValueEnforcer.notNull(string, "Value");
        ValueEnforcer.notNull(charset, "Charset");
        return this.update(CharsetManager.getAsBytes(string, charset));
    }

    @Override
    @Nonnull
    public final IMessageDigestGenerator update(@Nonnull byte[] byArray) {
        ValueEnforcer.notNull(byArray, "Value");
        return this.update(byArray, 0, byArray.length);
    }

    @Override
    public final long getDigestLong() {
        return MessageDigestGeneratorHelper.getLongFromDigest(this.getAllDigestBytes());
    }

    @Override
    @Nonnull
    public final String getDigestHexString() {
        return MessageDigestGeneratorHelper.getHexValueFromDigest(this.getAllDigestBytes());
    }
}

