/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.io.stream;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.callback.INonThrowingRunnableWithParameter;
import com.helger.commons.charset.CCharset;
import com.helger.commons.charset.CharsetManager;
import com.helger.commons.exception.mock.IMockException;
import com.helger.commons.io.IHasInputStream;
import com.helger.commons.io.stream.ByteBufferInputStream;
import com.helger.commons.io.stream.ByteBufferOutputStream;
import com.helger.commons.io.stream.NonBlockingBufferedInputStream;
import com.helger.commons.io.stream.NonBlockingBufferedOutputStream;
import com.helger.commons.io.stream.NonBlockingBufferedReader;
import com.helger.commons.io.stream.NonBlockingBufferedWriter;
import com.helger.commons.io.stream.NonBlockingByteArrayInputStream;
import com.helger.commons.io.stream.NonBlockingByteArrayOutputStream;
import com.helger.commons.io.stream.NonBlockingStringReader;
import com.helger.commons.io.stream.NonBlockingStringWriter;
import com.helger.commons.io.stream.WrappedInputStream;
import com.helger.commons.io.stream.WrappedOutputStream;
import com.helger.commons.io.stream.WrappedReader;
import com.helger.commons.io.stream.WrappedWriter;
import com.helger.commons.mutable.MutableLong;
import com.helger.commons.state.ESuccess;
import com.helger.commons.statistics.IMutableStatisticsHandlerSize;
import com.helger.commons.statistics.StatisticsManager;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.Flushable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.CheckForSigned;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.WillClose;
import javax.annotation.WillNotClose;
import javax.annotation.concurrent.Immutable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public final class StreamHelper {
    private static final int DEFAULT_BUFSIZE = 16384;
    private static final Logger s_aLogger = LoggerFactory.getLogger(StreamHelper.class);
    private static final IMutableStatisticsHandlerSize s_aByteSizeHdl = StatisticsManager.getSizeHandler(StreamHelper.class.getName() + "$COPY");
    private static final IMutableStatisticsHandlerSize s_aCharSizeHdl = StatisticsManager.getSizeHandler(StreamHelper.class.getName() + "$COPYCHARS");
    private static final StreamHelper s_aInstance = new StreamHelper();

    private StreamHelper() {
    }

    public static boolean isKnownEOFException(@Nullable Throwable throwable) {
        return throwable != null && StreamHelper.isKnownEOFException(throwable.getClass());
    }

    public static boolean isKnownEOFException(@Nullable Class<?> clazz) {
        if (clazz == null) {
            return false;
        }
        String string = clazz.getName();
        return string.equals("java.io.EOFException") || string.equals("org.mortbay.jetty.EofException") || string.equals("org.eclipse.jetty.io.EofException") || string.equals("org.apache.catalina.connector.ClientAbortException");
    }

    @Nonnull
    public static ESuccess closeWithoutFlush(@Nullable @WillClose Closeable closeable) {
        block3: {
            if (closeable != null) {
                try {
                    closeable.close();
                    return ESuccess.SUCCESS;
                }
                catch (IOException iOException) {
                    if (StreamHelper.isKnownEOFException(iOException)) break block3;
                    s_aLogger.error("Failed to close stream " + closeable.getClass().getName(), (Throwable)(iOException instanceof IMockException ? null : iOException));
                }
            }
        }
        return ESuccess.FAILURE;
    }

    @Nonnull
    public static ESuccess close(@Nullable @WillClose Closeable closeable) {
        block5: {
            if (closeable != null) {
                try {
                    if (closeable instanceof Flushable) {
                        StreamHelper.flush((Flushable)((Object)closeable));
                    }
                    closeable.close();
                    return ESuccess.SUCCESS;
                }
                catch (NullPointerException nullPointerException) {
                }
                catch (IOException iOException) {
                    if (StreamHelper.isKnownEOFException(iOException)) break block5;
                    s_aLogger.error("Failed to close object " + closeable.getClass().getName(), (Throwable)(iOException instanceof IMockException ? null : iOException));
                }
            }
        }
        return ESuccess.FAILURE;
    }

    @Nonnull
    public static ESuccess flush(@Nullable Flushable flushable) {
        block4: {
            if (flushable != null) {
                try {
                    flushable.flush();
                    return ESuccess.SUCCESS;
                }
                catch (NullPointerException nullPointerException) {
                }
                catch (IOException iOException) {
                    if (StreamHelper.isKnownEOFException(iOException)) break block4;
                    s_aLogger.error("Failed to flush object " + flushable.getClass().getName(), (Throwable)(iOException instanceof IMockException ? null : iOException));
                }
            }
        }
        return ESuccess.FAILURE;
    }

    @Nonnull
    public static ESuccess copyInputStreamToOutputStreamAndCloseOS(@WillClose @Nullable InputStream inputStream, @WillClose @Nullable OutputStream outputStream) {
        try {
            ESuccess eSuccess = StreamHelper.copyInputStreamToOutputStream(inputStream, outputStream, new byte[16384], null, null);
            return eSuccess;
        }
        finally {
            StreamHelper.close(outputStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public static ESuccess copyInputStreamToOutputStreamWithLimitAndCloseOS(@WillClose @Nullable InputStream inputStream, @WillClose @Nullable OutputStream outputStream, @Nonnegative long l) {
        try {
            ESuccess eSuccess = StreamHelper.copyInputStreamToOutputStream(inputStream, outputStream, new byte[16384], null, l);
            return eSuccess;
        }
        finally {
            StreamHelper.close(outputStream);
        }
    }

    @Nonnull
    public static ESuccess copyInputStreamToOutputStream(@WillClose @Nullable InputStream inputStream, @WillNotClose @Nullable OutputStream outputStream) {
        return StreamHelper.copyInputStreamToOutputStream(inputStream, outputStream, new byte[16384], null, null);
    }

    @Nonnull
    public static ESuccess copyInputStreamToOutputStream(@WillClose @Nullable InputStream inputStream, @WillNotClose @Nullable OutputStream outputStream, @Nullable MutableLong mutableLong) {
        return StreamHelper.copyInputStreamToOutputStream(inputStream, outputStream, new byte[16384], mutableLong, null);
    }

    @Nonnull
    public static ESuccess copyInputStreamToOutputStreamWithLimit(@WillClose @Nullable InputStream inputStream, @WillNotClose @Nullable OutputStream outputStream, @Nonnegative long l) {
        return StreamHelper.copyInputStreamToOutputStream(inputStream, outputStream, new byte[16384], null, l);
    }

    @Nonnull
    public static ESuccess copyInputStreamToOutputStream(@WillClose @Nullable InputStream inputStream, @WillNotClose @Nullable OutputStream outputStream, @Nonnull byte[] byArray) {
        return StreamHelper.copyInputStreamToOutputStream(inputStream, outputStream, byArray, null, null);
    }

    @Nonnegative
    private static long _copyInputStreamToOutputStream(@Nonnull @WillNotClose InputStream inputStream, @Nonnull @WillNotClose OutputStream outputStream, @Nonnull @WillNotClose byte[] byArray) throws IOException {
        int n;
        long l = 0L;
        while ((n = inputStream.read(byArray, 0, byArray.length)) > -1) {
            outputStream.write(byArray, 0, n);
            l += (long)n;
        }
        return l;
    }

    @Nonnegative
    private static long _copyInputStreamToOutputStreamWithLimit(@Nonnull @WillNotClose InputStream inputStream, @Nonnull @WillNotClose OutputStream outputStream, @Nonnull byte[] byArray, @Nonnegative long l) throws IOException {
        long l2 = l;
        long l3 = 0L;
        while (true) {
            int n;
            int n2;
            int n3 = n2 = l2 >= (long)byArray.length ? byArray.length : (int)l2;
            if (n2 == 0 || (n = inputStream.read(byArray, 0, n2)) == -1) break;
            if (n <= 0) continue;
            outputStream.write(byArray, 0, n);
            l3 += (long)n;
            l2 -= (long)n;
        }
        return l3;
    }

    @Nonnull
    public static ESuccess copyInputStreamToOutputStream(@WillClose @Nullable InputStream inputStream, @WillNotClose @Nullable OutputStream outputStream, @Nonnull @Nonempty byte[] byArray, @Nullable MutableLong mutableLong) {
        return StreamHelper.copyInputStreamToOutputStream(inputStream, outputStream, byArray, mutableLong, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public static ESuccess copyInputStreamToOutputStream(@WillClose @Nullable InputStream inputStream, @WillNotClose @Nullable OutputStream outputStream, @Nonnull @Nonempty byte[] byArray, @Nullable MutableLong mutableLong, @Nullable Long l) {
        ValueEnforcer.notEmpty(byArray, "Buffer");
        if (l != null && l < 0L) {
            throw new IllegalArgumentException("Limit may not be negative!");
        }
        try {
            if (inputStream != null && outputStream != null) {
                long l2 = l == null ? StreamHelper._copyInputStreamToOutputStream(inputStream, outputStream, byArray) : StreamHelper._copyInputStreamToOutputStreamWithLimit(inputStream, outputStream, byArray, l);
                s_aByteSizeHdl.addSize(l2);
                if (mutableLong != null) {
                    mutableLong.set(l2);
                }
                ESuccess eSuccess = ESuccess.SUCCESS;
                return eSuccess;
            }
        }
        catch (IOException iOException) {
            if (!StreamHelper.isKnownEOFException(iOException)) {
                s_aLogger.error("Failed to copy from stream to stream", (Throwable)(iOException instanceof IMockException ? null : iOException));
            }
        }
        finally {
            StreamHelper.close(inputStream);
        }
        return ESuccess.FAILURE;
    }

    public static int getAvailable(@Nullable InputStream inputStream) {
        if (inputStream != null) {
            try {
                return inputStream.available();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return 0;
    }

    @Nonnull
    public static NonBlockingByteArrayOutputStream getCopy(@Nonnull @WillClose InputStream inputStream) {
        int n = Math.max(16384, StreamHelper.getAvailable(inputStream));
        NonBlockingByteArrayOutputStream nonBlockingByteArrayOutputStream = new NonBlockingByteArrayOutputStream(n);
        StreamHelper.copyInputStreamToOutputStreamAndCloseOS(inputStream, nonBlockingByteArrayOutputStream);
        return nonBlockingByteArrayOutputStream;
    }

    @Nonnull
    public static NonBlockingByteArrayOutputStream getCopyWithLimit(@Nonnull @WillClose InputStream inputStream, @Nonnegative long l) {
        int n = Math.max(16384, StreamHelper.getAvailable(inputStream));
        NonBlockingByteArrayOutputStream nonBlockingByteArrayOutputStream = new NonBlockingByteArrayOutputStream(n);
        StreamHelper.copyInputStreamToOutputStreamWithLimitAndCloseOS(inputStream, nonBlockingByteArrayOutputStream, l);
        return nonBlockingByteArrayOutputStream;
    }

    @Nullable
    public static byte[] getAllBytes(@Nullable IHasInputStream iHasInputStream) {
        if (iHasInputStream == null) {
            return null;
        }
        return StreamHelper.getAllBytes(iHasInputStream.getInputStream());
    }

    @Nullable
    public static byte[] getAllBytes(@Nullable @WillClose InputStream inputStream) {
        if (inputStream == null) {
            return null;
        }
        return StreamHelper.getCopy(inputStream).toByteArray();
    }

    @Nullable
    public static String getAllBytesAsString(@Nullable IHasInputStream iHasInputStream, @Nonnull @Nonempty Charset charset) {
        if (iHasInputStream == null) {
            return null;
        }
        return StreamHelper.getAllBytesAsString(iHasInputStream.getInputStream(), charset);
    }

    @Nullable
    public static String getAllBytesAsString(@Nullable @WillClose InputStream inputStream, @Nonnull @Nonempty Charset charset) {
        ValueEnforcer.notNull(charset, "Charset");
        if (inputStream == null) {
            return null;
        }
        return StreamHelper.getCopy(inputStream).getAsString(charset);
    }

    @Nonnull
    public static ESuccess copyReaderToWriterAndCloseWriter(@WillClose @Nullable Reader reader, @WillClose @Nullable Writer writer) {
        try {
            ESuccess eSuccess = StreamHelper.copyReaderToWriter(reader, writer, new char[16384], null, null);
            return eSuccess;
        }
        finally {
            StreamHelper.close(writer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public static ESuccess copyReaderToWriterWithLimitAndCloseWriter(@WillClose @Nullable Reader reader, @WillClose @Nullable Writer writer, @Nonnegative long l) {
        try {
            ESuccess eSuccess = StreamHelper.copyReaderToWriter(reader, writer, new char[16384], null, l);
            return eSuccess;
        }
        finally {
            StreamHelper.close(writer);
        }
    }

    @Nonnull
    public static ESuccess copyReaderToWriter(@WillClose @Nullable Reader reader, @WillNotClose @Nullable Writer writer) {
        return StreamHelper.copyReaderToWriter(reader, writer, new char[16384], null, null);
    }

    @Nonnull
    public static ESuccess copyReaderToWriter(@WillClose @Nullable Reader reader, @WillNotClose @Nullable Writer writer, @Nullable MutableLong mutableLong) {
        return StreamHelper.copyReaderToWriter(reader, writer, new char[16384], mutableLong, null);
    }

    @Nonnull
    public static ESuccess copyReaderToWriter(@WillClose @Nullable Reader reader, @WillNotClose @Nullable Writer writer, @Nonnull char[] cArray) {
        return StreamHelper.copyReaderToWriter(reader, writer, cArray, null, null);
    }

    @Nonnull
    public static ESuccess copyReaderToWriterWithLimit(@WillClose @Nullable Reader reader, @WillNotClose @Nullable Writer writer, long l) {
        return StreamHelper.copyReaderToWriter(reader, writer, new char[16384], null, l);
    }

    @Nonnegative
    private static long _copyReaderToWriter(@Nonnull Reader reader, @Nonnull Writer writer, @Nonnull char[] cArray) throws IOException {
        int n;
        long l = 0L;
        while ((n = reader.read(cArray, 0, cArray.length)) > -1) {
            writer.write(cArray, 0, n);
            l += (long)n;
        }
        return l;
    }

    @Nonnegative
    private static long _copyReaderToWriterWithLimit(@Nonnull Reader reader, @Nonnull Writer writer, @Nonnull char[] cArray, @Nonnegative long l) throws IOException {
        long l2 = l;
        long l3 = 0L;
        while (true) {
            int n;
            int n2;
            int n3 = n2 = l2 >= (long)cArray.length ? cArray.length : (int)l2;
            if (n2 == 0 || (n = reader.read(cArray, 0, n2)) == -1) break;
            if (n <= 0) continue;
            writer.write(cArray, 0, n);
            l3 += (long)n;
            l2 -= (long)n;
        }
        return l3;
    }

    @Nonnull
    public static ESuccess copyReaderToWriter(@WillClose @Nullable Reader reader, @WillNotClose @Nullable Writer writer, @Nonnull @Nonempty char[] cArray, @Nullable MutableLong mutableLong) {
        return StreamHelper.copyReaderToWriter(reader, writer, cArray, mutableLong, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public static ESuccess copyReaderToWriter(@WillClose @Nullable Reader reader, @WillNotClose @Nullable Writer writer, @Nonnull @Nonempty char[] cArray, @Nullable MutableLong mutableLong, @Nullable Long l) {
        ValueEnforcer.notEmpty(cArray, "Buffer");
        if (l != null) {
            ValueEnforcer.isGE0(l, "Limit");
        }
        try {
            if (reader != null && writer != null) {
                long l2 = l == null ? StreamHelper._copyReaderToWriter(reader, writer, cArray) : StreamHelper._copyReaderToWriterWithLimit(reader, writer, cArray, l);
                s_aCharSizeHdl.addSize(l2);
                if (mutableLong != null) {
                    mutableLong.set(l2);
                }
                ESuccess eSuccess = ESuccess.SUCCESS;
                return eSuccess;
            }
        }
        catch (IOException iOException) {
            if (!StreamHelper.isKnownEOFException(iOException)) {
                s_aLogger.error("Failed to copy from reader to writer", (Throwable)(iOException instanceof IMockException ? null : iOException));
            }
        }
        finally {
            StreamHelper.close(reader);
        }
        return ESuccess.FAILURE;
    }

    @Nonnull
    public static NonBlockingStringWriter getCopy(@Nonnull @WillClose Reader reader) {
        NonBlockingStringWriter nonBlockingStringWriter = new NonBlockingStringWriter(16384);
        StreamHelper.copyReaderToWriterAndCloseWriter(reader, nonBlockingStringWriter);
        return nonBlockingStringWriter;
    }

    @Nonnull
    public static NonBlockingStringWriter getCopyWithLimit(@Nonnull @WillClose Reader reader, @Nonnegative long l) {
        NonBlockingStringWriter nonBlockingStringWriter = new NonBlockingStringWriter(16384);
        StreamHelper.copyReaderToWriterWithLimitAndCloseWriter(reader, nonBlockingStringWriter, l);
        return nonBlockingStringWriter;
    }

    @Nullable
    public static char[] getAllCharacters(@Nullable @WillClose Reader reader) {
        if (reader == null) {
            return null;
        }
        return StreamHelper.getCopy(reader).getAsCharArray();
    }

    @Nullable
    public static String getAllCharactersAsString(@Nullable @WillClose Reader reader) {
        if (reader == null) {
            return null;
        }
        return StreamHelper.getCopy(reader).getAsString();
    }

    @Nullable
    @ReturnsMutableCopy
    public static List<String> readStreamLines(@Nullable IHasInputStream iHasInputStream, @Nonnull Charset charset) {
        return StreamHelper.readStreamLines(iHasInputStream, charset, 0, -1);
    }

    @Nullable
    @ReturnsMutableCopy
    public static List<String> readStreamLines(@Nullable IHasInputStream iHasInputStream, @Nonnull Charset charset, @Nonnegative int n, @CheckForSigned int n2) {
        if (iHasInputStream == null) {
            return null;
        }
        return StreamHelper.readStreamLines(iHasInputStream.getInputStream(), charset, n, n2);
    }

    @Nullable
    @ReturnsMutableCopy
    public static List<String> readStreamLines(@WillClose @Nullable InputStream inputStream, @Nonnull @Nonempty Charset charset) {
        return StreamHelper.readStreamLines(inputStream, charset, 0, -1);
    }

    public static void readStreamLines(@WillClose @Nullable InputStream inputStream, @Nonnull Charset charset, final @Nonnull List<String> list) {
        if (inputStream != null) {
            StreamHelper.readStreamLines(inputStream, charset, 0, -1, new INonThrowingRunnableWithParameter<String>(){

                @Override
                public void run(String string) {
                    list.add(string);
                }
            });
        }
    }

    @Nullable
    @ReturnsMutableCopy
    public static List<String> readStreamLines(@WillClose @Nullable InputStream inputStream, @Nonnull Charset charset, @Nonnegative int n, @CheckForSigned int n2) {
        if (inputStream == null) {
            return null;
        }
        final ArrayList<String> arrayList = new ArrayList<String>();
        StreamHelper.readStreamLines(inputStream, charset, n, n2, new INonThrowingRunnableWithParameter<String>(){

            @Override
            public void run(String string) {
                arrayList.add(string);
            }
        });
        return arrayList;
    }

    public static void readStreamLines(@WillClose @Nullable InputStream inputStream, @Nonnull @Nonempty Charset charset, @Nonnull INonThrowingRunnableWithParameter<String> iNonThrowingRunnableWithParameter) {
        StreamHelper.readStreamLines(inputStream, charset, 0, -1, iNonThrowingRunnableWithParameter);
    }

    private static void _readFromReader(int n, int n2, INonThrowingRunnableWithParameter<String> iNonThrowingRunnableWithParameter, boolean bl, NonBlockingBufferedReader nonBlockingBufferedReader) throws IOException {
        String string;
        int n3;
        for (n3 = 0; n3 < n && (string = nonBlockingBufferedReader.readLine()) != null; ++n3) {
        }
        if (bl) {
            while ((string = nonBlockingBufferedReader.readLine()) != null) {
                iNonThrowingRunnableWithParameter.run(string);
            }
        } else {
            n3 = 0;
            while ((string = nonBlockingBufferedReader.readLine()) != null) {
                iNonThrowingRunnableWithParameter.run(string);
                if (++n3 < n2) continue;
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void readStreamLines(@WillClose @Nullable InputStream inputStream, @Nonnull @Nonempty Charset charset, @Nonnegative int n, int n2, @Nonnull INonThrowingRunnableWithParameter<String> iNonThrowingRunnableWithParameter) {
        block9: {
            boolean bl;
            ValueEnforcer.notNull(charset, "Charset");
            ValueEnforcer.isGE0(n, "LinesToSkip");
            boolean bl2 = bl = n2 == -1;
            if (n2 < 0 && !bl) {
                throw new IllegalArgumentException("Line count may not be that negative: " + n2);
            }
            ValueEnforcer.notNull(iNonThrowingRunnableWithParameter, "LineCallback");
            if (inputStream != null) {
                try {
                    if (!bl && n2 <= 0) break block9;
                    NonBlockingBufferedReader nonBlockingBufferedReader = null;
                    try {
                        nonBlockingBufferedReader = new NonBlockingBufferedReader(StreamHelper.createReader(inputStream, charset));
                        StreamHelper._readFromReader(n, n2, iNonThrowingRunnableWithParameter, bl, nonBlockingBufferedReader);
                    }
                    catch (IOException iOException) {
                        try {
                            s_aLogger.error("Failed to read from input stream", (Throwable)(iOException instanceof IMockException ? null : iOException));
                        }
                        catch (Throwable throwable) {
                            StreamHelper.close(nonBlockingBufferedReader);
                            throw throwable;
                        }
                        StreamHelper.close(nonBlockingBufferedReader);
                        break block9;
                    }
                    StreamHelper.close(nonBlockingBufferedReader);
                }
                finally {
                    StreamHelper.close(inputStream);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public static ESuccess writeStream(@WillClose @Nonnull OutputStream outputStream, @Nonnull byte[] byArray, @Nonnegative int n, @Nonnegative int n2) {
        ValueEnforcer.notNull(outputStream, "OutputStream");
        ValueEnforcer.isArrayOfsLen(byArray, n, n2);
        try {
            outputStream.write(byArray, n, n2);
            outputStream.flush();
            ESuccess eSuccess = ESuccess.SUCCESS;
            return eSuccess;
        }
        catch (IOException iOException) {
            s_aLogger.error("Failed to write to output stream", (Throwable)(iOException instanceof IMockException ? null : iOException));
            ESuccess eSuccess = ESuccess.FAILURE;
            return eSuccess;
        }
        finally {
            StreamHelper.close(outputStream);
        }
    }

    @Nonnull
    public static ESuccess writeStream(@WillClose @Nonnull OutputStream outputStream, @Nonnull byte[] byArray) {
        return StreamHelper.writeStream(outputStream, byArray, 0, byArray.length);
    }

    @Nonnull
    public static ESuccess writeStream(@WillClose @Nonnull OutputStream outputStream, @Nonnull String string, @Nonnull Charset charset) {
        ValueEnforcer.notNull(string, "Content");
        ValueEnforcer.notNull(charset, "Charset");
        return StreamHelper.writeStream(outputStream, CharsetManager.getAsBytes(string, charset));
    }

    @Nonnull
    public static NonBlockingStringReader createReader(@Nonnull String string) {
        return new NonBlockingStringReader(string);
    }

    @Nonnull
    public static NonBlockingStringReader createReader(@Nonnull char[] cArray) {
        return new NonBlockingStringReader(cArray);
    }

    @Nullable
    public static InputStreamReader createReader(@Nullable InputStream inputStream, @Nonnull Charset charset) {
        return inputStream == null ? null : new InputStreamReader(inputStream, charset);
    }

    @Nullable
    public static OutputStreamWriter createWriter(@Nullable OutputStream outputStream, @Nonnull Charset charset) {
        return outputStream == null ? null : new OutputStreamWriter(outputStream, charset);
    }

    public static void skipFully(@Nonnull InputStream inputStream, @Nonnegative long l) throws IOException {
        ValueEnforcer.notNull(inputStream, "InputStream");
        ValueEnforcer.isGE0(l, "BytesToSkip");
        long l2 = l;
        while (l2 > 0L) {
            long l3 = inputStream.skip(l2);
            if (l3 == 0L) {
                if (inputStream.read() == -1) {
                    throw new EOFException("Failed to skip a total of " + l + " bytes on input stream. Only skipped " + (l - l2) + " bytes so far!");
                }
                --l2;
                continue;
            }
            l2 -= l3;
        }
    }

    @Nonnegative
    public static int readFully(@Nonnull InputStream inputStream, @Nonnull byte[] byArray) throws IOException {
        return StreamHelper.readFully(inputStream, byArray, 0, byArray.length);
    }

    @Nonnegative
    public static int readFully(@Nonnull InputStream inputStream, @Nonnull byte[] byArray, @Nonnegative int n, @Nonnegative int n2) throws IOException {
        int n3;
        int n4;
        ValueEnforcer.notNull(inputStream, "InputStream");
        ValueEnforcer.isArrayOfsLen(byArray, n, n2);
        for (n3 = 0; n3 < n2; n3 += n4) {
            n4 = inputStream.read(byArray, n + n3, n2 - n3);
            if (n4 >= 0) continue;
            throw new EOFException("Failed to read a total of " + n2 + " bytes from input stream. Only read " + n3 + " bytes so far.");
        }
        return n3;
    }

    public static boolean isBuffered(@Nullable InputStream inputStream) {
        return inputStream instanceof BufferedInputStream || inputStream instanceof NonBlockingBufferedInputStream || inputStream instanceof ByteArrayInputStream || inputStream instanceof NonBlockingByteArrayInputStream || inputStream instanceof ByteBufferInputStream || inputStream instanceof WrappedInputStream && StreamHelper.isBuffered(((WrappedInputStream)inputStream).getWrappedInputStream());
    }

    @Nullable
    public static InputStream getBuffered(@Nullable InputStream inputStream) {
        return inputStream == null || StreamHelper.isBuffered(inputStream) ? inputStream : new NonBlockingBufferedInputStream(inputStream);
    }

    public static boolean isBuffered(@Nullable OutputStream outputStream) {
        return outputStream instanceof BufferedOutputStream || outputStream instanceof NonBlockingBufferedOutputStream || outputStream instanceof ByteArrayOutputStream || outputStream instanceof NonBlockingByteArrayOutputStream || outputStream instanceof ByteBufferOutputStream || outputStream instanceof WrappedOutputStream && StreamHelper.isBuffered(((WrappedOutputStream)outputStream).getWrappedOutputStream());
    }

    @Nullable
    public static OutputStream getBuffered(@Nullable OutputStream outputStream) {
        return outputStream == null || StreamHelper.isBuffered(outputStream) ? outputStream : new NonBlockingBufferedOutputStream(outputStream);
    }

    public static boolean isBuffered(@Nullable Reader reader) {
        return reader instanceof BufferedReader || reader instanceof NonBlockingBufferedReader || reader instanceof StringReader || reader instanceof NonBlockingStringReader || reader instanceof WrappedReader && StreamHelper.isBuffered(((WrappedReader)reader).getWrappedReader());
    }

    @Nullable
    public static Reader getBuffered(@Nullable Reader reader) {
        return reader == null || StreamHelper.isBuffered(reader) ? reader : new NonBlockingBufferedReader(reader);
    }

    public static boolean isBuffered(@Nullable Writer writer) {
        return writer instanceof BufferedWriter || writer instanceof NonBlockingBufferedWriter || writer instanceof StringWriter || writer instanceof NonBlockingStringWriter || writer instanceof WrappedWriter && StreamHelper.isBuffered(((WrappedWriter)writer).getWrappedWriter());
    }

    @Nullable
    public static Writer getBuffered(@Nullable Writer writer) {
        return writer == null || StreamHelper.isBuffered(writer) ? writer : new NonBlockingBufferedWriter(writer);
    }

    @Nullable
    public static InputStream checkForInvalidFilterInputStream(@Nullable InputStream inputStream) {
        if (inputStream != null) {
            try {
                inputStream.markSupported();
            }
            catch (NullPointerException nullPointerException) {
                StreamHelper.close(inputStream);
                return null;
            }
        }
        return inputStream;
    }

    public static void writeSafeUTF(@Nonnull DataOutputStream dataOutputStream, @Nullable String string) throws IOException {
        if (string == null) {
            dataOutputStream.writeByte(0);
        } else {
            dataOutputStream.writeByte(1);
            byte[] byArray = string.getBytes(CCharset.CHARSET_UTF_8_OBJ);
            dataOutputStream.writeInt(byArray.length);
            dataOutputStream.write(byArray);
        }
    }

    @Nullable
    public static String readSafeUTF(@Nonnull DataInputStream dataInputStream) throws IOException {
        if (dataInputStream.readByte() == 0) {
            return null;
        }
        int n = dataInputStream.readInt();
        byte[] byArray = new byte[n];
        dataInputStream.read(byArray);
        return new String(byArray, CCharset.CHARSET_UTF_8_OBJ);
    }
}

