/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.compare;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.compare.AbstractComparator;
import com.helger.commons.compare.CollatorHelper;
import com.helger.commons.string.ToStringGenerator;
import java.text.Collator;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class CollatingComparator
extends AbstractComparator<String> {
    private final Collator m_aCollator;

    public CollatingComparator(@Nullable Locale locale) {
        this.m_aCollator = CollatorHelper.getCollatorSpaceBeforeDot(locale);
    }

    public CollatingComparator(@Nonnull Collator collator) {
        ValueEnforcer.notNull(collator, "Collator");
        this.m_aCollator = (Collator)collator.clone();
    }

    @Nonnull
    @ReturnsMutableCopy
    public final Collator getCollator() {
        return (Collator)this.m_aCollator.clone();
    }

    @Override
    protected final int mainCompare(@Nonnull String string, @Nonnull String string2) {
        return this.m_aCollator.compare(string, string2);
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived(super.toString()).append("collator", this.m_aCollator).toString();
    }
}

