/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.collection.multimap;

import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.collection.multimap.IMultiMap;
import com.helger.commons.collection.multimap.MultiMapHelper;
import com.helger.commons.state.EChange;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public abstract class AbstractMultiConcurrentHashMap<KEYTYPE, VALUETYPE, COLLTYPE extends Collection<VALUETYPE>>
extends ConcurrentHashMap<KEYTYPE, COLLTYPE>
implements IMultiMap<KEYTYPE, VALUETYPE, COLLTYPE> {
    public AbstractMultiConcurrentHashMap() {
    }

    public AbstractMultiConcurrentHashMap(@Nonnull KEYTYPE KEYTYPE, @Nullable VALUETYPE VALUETYPE) {
        this.putSingle(KEYTYPE, VALUETYPE);
    }

    public AbstractMultiConcurrentHashMap(@Nonnull KEYTYPE KEYTYPE, @Nonnull COLLTYPE COLLTYPE) {
        this.put(KEYTYPE, COLLTYPE);
    }

    public AbstractMultiConcurrentHashMap(@Nullable Map<? extends KEYTYPE, ? extends COLLTYPE> map) {
        if (map != null) {
            this.putAll(map);
        }
    }

    @Nonnull
    @ReturnsMutableCopy
    protected abstract COLLTYPE createNewCollection();

    @Override
    @Nonnull
    @ReturnsMutableObject(value="design")
    public COLLTYPE getOrCreate(@Nonnull KEYTYPE KEYTYPE) {
        Collection<Object> collection = (Collection)this.get(KEYTYPE);
        if (collection == null) {
            collection = this.createNewCollection();
            super.put(KEYTYPE, collection);
        }
        return (COLLTYPE)collection;
    }

    @Override
    @Nonnull
    public final EChange putSingle(@Nonnull KEYTYPE KEYTYPE, @Nullable VALUETYPE VALUETYPE) {
        return EChange.valueOf(this.getOrCreate(KEYTYPE).add(VALUETYPE));
    }

    @Override
    @Nonnull
    public final EChange putAllIn(@Nonnull Map<? extends KEYTYPE, ? extends VALUETYPE> map) {
        EChange eChange = EChange.UNCHANGED;
        for (Map.Entry<KEYTYPE, VALUETYPE> entry : map.entrySet()) {
            eChange = eChange.or(this.putSingle(entry.getKey(), entry.getValue()));
        }
        return eChange;
    }

    @Override
    @Nonnull
    public final EChange removeSingle(@Nonnull KEYTYPE KEYTYPE, @Nullable VALUETYPE VALUETYPE) {
        Collection collection = (Collection)this.get(KEYTYPE);
        return collection == null ? EChange.UNCHANGED : EChange.valueOf(collection.remove(VALUETYPE));
    }

    @Override
    public final boolean containsSingle(@Nonnull KEYTYPE KEYTYPE, @Nullable VALUETYPE VALUETYPE) {
        Collection collection = (Collection)this.get(KEYTYPE);
        return collection != null && collection.contains(VALUETYPE);
    }

    @Override
    @Nonnegative
    public final long getTotalValueCount() {
        return MultiMapHelper.getTotalValueCount(this);
    }
}

