/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.collection.iterate;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.collection.iterate.IIterableIterator;
import com.helger.commons.convert.IConverter;
import com.helger.commons.string.ToStringGenerator;
import java.util.Iterator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ConvertIterator<SRCTYPE, ELEMENTTYPE>
implements IIterableIterator<ELEMENTTYPE> {
    private final Iterator<? extends SRCTYPE> m_aBaseIter;
    private final IConverter<SRCTYPE, ELEMENTTYPE> m_aConverter;

    public ConvertIterator(@Nonnull IIterableIterator<? extends SRCTYPE> iIterableIterator, @Nonnull IConverter<SRCTYPE, ELEMENTTYPE> iConverter) {
        this(iIterableIterator.iterator(), iConverter);
    }

    public ConvertIterator(@Nonnull Iterable<? extends SRCTYPE> iterable, @Nonnull IConverter<SRCTYPE, ELEMENTTYPE> iConverter) {
        this(iterable.iterator(), iConverter);
    }

    public ConvertIterator(@Nonnull Iterator<? extends SRCTYPE> iterator, @Nonnull IConverter<SRCTYPE, ELEMENTTYPE> iConverter) {
        this.m_aBaseIter = ValueEnforcer.notNull(iterator, "BaseIterator");
        this.m_aConverter = ValueEnforcer.notNull(iConverter, "Filter");
    }

    @Nonnull
    public IConverter<SRCTYPE, ELEMENTTYPE> getConverter() {
        return this.m_aConverter;
    }

    @Override
    public boolean hasNext() {
        return this.m_aBaseIter.hasNext();
    }

    @Override
    @Nullable
    public ELEMENTTYPE next() {
        SRCTYPE SRCTYPE = this.m_aBaseIter.next();
        return this.m_aConverter.convert(SRCTYPE);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    @Nonnull
    public Iterator<ELEMENTTYPE> iterator() {
        return this;
    }

    public String toString() {
        return new ToStringGenerator(this).append("baseIter", this.m_aBaseIter).append("converter", this.m_aConverter).toString();
    }
}

