/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.codec;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.base64.Base64;
import com.helger.commons.charset.CCharset;
import com.helger.commons.codec.AbstractRFC1522Codec;
import com.helger.commons.codec.DecodeException;
import com.helger.commons.codec.EncodeException;
import java.nio.charset.Charset;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class RFC1522BCodec
extends AbstractRFC1522Codec {
    private final Charset m_aCharset;

    public RFC1522BCodec() {
        this(CCharset.CHARSET_UTF_8_OBJ);
    }

    public RFC1522BCodec(@Nonnull Charset charset) {
        this.m_aCharset = ValueEnforcer.notNull(charset, "Charset");
    }

    @Override
    protected String getRFC1522Encoding() {
        return "B";
    }

    @Nonnull
    public Charset getCharset() {
        return this.m_aCharset;
    }

    @Override
    @Nullable
    @ReturnsMutableCopy
    public byte[] getEncoded(@Nullable byte[] byArray) {
        return Base64.safeEncodeBytesToBytes(byArray);
    }

    @Override
    @Nullable
    @ReturnsMutableCopy
    public byte[] getDecoded(@Nullable byte[] byArray) {
        return Base64.safeDecode(byArray);
    }

    @Nullable
    public String getEncodedText(@Nullable String string) throws EncodeException {
        return super.getEncodedText(string, this.getCharset());
    }

    @Override
    @Nullable
    public String getDecodedText(@Nullable String string) throws DecodeException {
        return super.getDecodedText(string);
    }
}

