/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.aggregate;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.aggregate.AbstractAggregator;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class AggregatorStringWithSeparator
extends AbstractAggregator<String, String> {
    private final String m_sSep;

    public AggregatorStringWithSeparator(@Nonnull String string) {
        this.m_sSep = ValueEnforcer.notNull(string, "Separator");
    }

    @Nonnull
    public String getSeparator() {
        return this.m_sSep;
    }

    @Override
    @Nonnull
    public String aggregate(@Nonnull Collection<String> collection) {
        return StringHelper.getImploded(this.m_sSep, collection);
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        AggregatorStringWithSeparator aggregatorStringWithSeparator = (AggregatorStringWithSeparator)object;
        return this.m_sSep.equals(aggregatorStringWithSeparator.m_sSep);
    }

    @Override
    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_sSep).getHashCode();
    }

    @Override
    public String toString() {
        return new ToStringGenerator(this).append("sep", this.m_sSep).toString();
    }
}

