/*
 * Decompiled with CFR 0.152.
 */
package com.helger.charset.utf7;

import com.helger.charset.utf7.AbstractUTF7StyleCharset;
import com.helger.charset.utf7.UTF7Base64Helper;
import com.helger.commons.system.SystemProperties;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import javax.annotation.Nonnull;

final class UTF7StyleCharsetEncoder
extends CharsetEncoder {
    private static final float AVG_BYTES_PER_CHAR = 1.5f;
    private static final float MAX_BYTES_PER_CHAR = 5.0f;
    private static final boolean s_bUseUglyHackToForceCallToFlushInJava5;
    private final AbstractUTF7StyleCharset m_aCharset;
    private final UTF7Base64Helper m_aBase64;
    private final byte m_nShift;
    private final byte m_nUnshift;
    private final boolean m_bStrict;
    private boolean m_bBase64mode;
    private int m_nBitsToOutput;
    private int m_nSextet;

    UTF7StyleCharsetEncoder(@Nonnull AbstractUTF7StyleCharset abstractUTF7StyleCharset, @Nonnull UTF7Base64Helper uTF7Base64Helper, boolean bl) {
        super(abstractUTF7StyleCharset, 1.5f, 5.0f);
        this.m_aCharset = abstractUTF7StyleCharset;
        this.m_aBase64 = uTF7Base64Helper;
        this.m_bStrict = bl;
        this.m_nShift = abstractUTF7StyleCharset.shift();
        this.m_nUnshift = abstractUTF7StyleCharset.unshift();
    }

    @Override
    protected void implReset() {
        this.m_bBase64mode = false;
        this.m_nSextet = 0;
        this.m_nBitsToOutput = 0;
    }

    @Override
    protected CoderResult implFlush(ByteBuffer byteBuffer) {
        if (this.m_bBase64mode) {
            if (byteBuffer.remaining() < 2) {
                return CoderResult.OVERFLOW;
            }
            if (this.m_nBitsToOutput != 0) {
                byteBuffer.put(this.m_aBase64.getChar(this.m_nSextet));
            }
            byteBuffer.put(this.m_nUnshift);
        }
        return CoderResult.UNDERFLOW;
    }

    @Override
    protected CoderResult encodeLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
        while (charBuffer.hasRemaining()) {
            if (byteBuffer.remaining() < 4) {
                return CoderResult.OVERFLOW;
            }
            char c = charBuffer.get();
            if (this.m_aCharset.canEncodeDirectly(c)) {
                this._unshift(byteBuffer, c);
                byteBuffer.put((byte)c);
                continue;
            }
            if (!this.m_bBase64mode && c == this.m_nShift) {
                byteBuffer.put(this.m_nShift);
                byteBuffer.put(this.m_nUnshift);
                continue;
            }
            this._encodeBase64(c, byteBuffer);
        }
        if (this.m_bBase64mode && s_bUseUglyHackToForceCallToFlushInJava5 && byteBuffer.limit() != (int)(5.0f * (float)charBuffer.limit())) {
            return CoderResult.OVERFLOW;
        }
        return CoderResult.UNDERFLOW;
    }

    private void _unshift(ByteBuffer byteBuffer, char c) {
        if (!this.m_bBase64mode) {
            return;
        }
        if (this.m_nBitsToOutput != 0) {
            byteBuffer.put(this.m_aBase64.getChar(this.m_nSextet));
        }
        if (this.m_aBase64.contains(c) || c == this.m_nUnshift || this.m_bStrict) {
            byteBuffer.put(this.m_nUnshift);
        }
        this.m_bBase64mode = false;
        this.m_nSextet = 0;
        this.m_nBitsToOutput = 0;
    }

    private void _encodeBase64(char c, ByteBuffer byteBuffer) {
        if (!this.m_bBase64mode) {
            byteBuffer.put(this.m_nShift);
        }
        this.m_bBase64mode = true;
        this.m_nBitsToOutput += 16;
        while (this.m_nBitsToOutput >= 6) {
            this.m_nBitsToOutput -= 6;
            this.m_nSextet += c >> this.m_nBitsToOutput;
            this.m_nSextet &= 0x3F;
            byteBuffer.put(this.m_aBase64.getChar(this.m_nSextet));
            this.m_nSextet = 0;
        }
        this.m_nSextet = c << 6 - this.m_nBitsToOutput & 0x3F;
    }

    static {
        String string = SystemProperties.getPropertyValue((String)"java.specification.version");
        String string2 = SystemProperties.getPropertyValue((String)"java.vm.vendor");
        s_bUseUglyHackToForceCallToFlushInJava5 = ("1.4".equals(string) || "1.5".equals(string)) && "Sun Microsystems Inc.".equals(string2);
    }
}

