/*
 * Decompiled with CFR 0.152.
 */
package com.helger.charset.utf7;

import com.helger.charset.utf7.AbstractUTF7StyleCharset;
import com.helger.charset.utf7.UTF7Base64Helper;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

final class UTF7StyleCharsetDecoder
extends CharsetDecoder {
    private final UTF7Base64Helper m_aBase64;
    private final byte m_nShift;
    private final byte m_nUnshift;
    private final boolean m_bStrict;
    private boolean m_bBase64mode;
    private int m_nBitsRead;
    private int m_nTempChar;
    private boolean m_bJustShifted;
    private boolean m_bJustUnshifted;

    UTF7StyleCharsetDecoder(AbstractUTF7StyleCharset abstractUTF7StyleCharset, UTF7Base64Helper uTF7Base64Helper, boolean bl) {
        super(abstractUTF7StyleCharset, 0.6f, 1.0f);
        this.m_aBase64 = uTF7Base64Helper;
        this.m_bStrict = bl;
        this.m_nShift = abstractUTF7StyleCharset.shift();
        this.m_nUnshift = abstractUTF7StyleCharset.unshift();
    }

    @Override
    protected CoderResult decodeLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
        while (byteBuffer.hasRemaining()) {
            byte by = byteBuffer.get();
            if (this.m_bBase64mode) {
                if (by == this.m_nUnshift) {
                    if (this._areBase64BitsWaiting()) {
                        return UTF7StyleCharsetDecoder._malformed(byteBuffer);
                    }
                    if (this.m_bJustShifted) {
                        if (!charBuffer.hasRemaining()) {
                            return this._overflow(byteBuffer);
                        }
                        charBuffer.put((char)this.m_nShift);
                    } else {
                        this.m_bJustUnshifted = true;
                    }
                    this._setUnshifted();
                } else {
                    if (!charBuffer.hasRemaining()) {
                        return this._overflow(byteBuffer);
                    }
                    CoderResult coderResult = this._handleBase64(byteBuffer, charBuffer, by);
                    if (coderResult != null) {
                        return coderResult;
                    }
                }
                this.m_bJustShifted = false;
                continue;
            }
            if (by == this.m_nShift) {
                this.m_bBase64mode = true;
                if (this.m_bJustUnshifted && this.m_bStrict) {
                    return UTF7StyleCharsetDecoder._malformed(byteBuffer);
                }
                this.m_bJustShifted = true;
                continue;
            }
            if (!charBuffer.hasRemaining()) {
                return this._overflow(byteBuffer);
            }
            charBuffer.put((char)by);
            this.m_bJustUnshifted = false;
        }
        return CoderResult.UNDERFLOW;
    }

    @Nonnull
    private CoderResult _overflow(@Nonnull ByteBuffer byteBuffer) {
        byteBuffer.position(byteBuffer.position() - 1);
        return CoderResult.OVERFLOW;
    }

    @Nullable
    private CoderResult _handleBase64(ByteBuffer byteBuffer, CharBuffer charBuffer, byte by) {
        CoderResult coderResult = null;
        int n = this.m_aBase64.getSextet(by);
        if (n >= 0) {
            this.m_nBitsRead += 6;
            if (this.m_nBitsRead < 16) {
                this.m_nTempChar += n << 16 - this.m_nBitsRead;
            } else {
                this.m_nBitsRead -= 16;
                this.m_nTempChar += n >> this.m_nBitsRead;
                charBuffer.put((char)this.m_nTempChar);
                this.m_nTempChar = n << 16 - this.m_nBitsRead & 0xFFFF;
            }
        } else {
            if (this.m_bStrict) {
                return UTF7StyleCharsetDecoder._malformed(byteBuffer);
            }
            charBuffer.put((char)by);
            if (this._areBase64BitsWaiting()) {
                coderResult = UTF7StyleCharsetDecoder._malformed(byteBuffer);
            }
            this._setUnshifted();
        }
        return coderResult;
    }

    @Override
    protected CoderResult implFlush(CharBuffer charBuffer) {
        if (this.m_bBase64mode && this.m_bStrict || this._areBase64BitsWaiting()) {
            return CoderResult.malformedForLength(1);
        }
        return CoderResult.UNDERFLOW;
    }

    @Override
    protected void implReset() {
        this._setUnshifted();
        this.m_bJustUnshifted = false;
    }

    private static CoderResult _malformed(@Nonnull ByteBuffer byteBuffer) {
        byteBuffer.position(byteBuffer.position() - 1);
        return CoderResult.malformedForLength(1);
    }

    private boolean _areBase64BitsWaiting() {
        return this.m_nTempChar != 0 || this.m_nBitsRead >= 6;
    }

    private void _setUnshifted() {
        this.m_bBase64mode = false;
        this.m_nBitsRead = 0;
        this.m_nTempChar = 0;
    }
}

