/*
 * Decompiled with CFR 0.152.
 */
package com.helger.charset.utf7;

import com.helger.charset.utf7.UTF7Charset;
import com.helger.charset.utf7.UTF7CharsetModified;
import com.helger.commons.annotation.IsSPIImplementation;
import com.helger.commons.collection.ext.CommonsArrayList;
import com.helger.commons.collection.ext.ICommonsList;
import java.nio.charset.Charset;
import java.nio.charset.spi.CharsetProvider;
import java.util.Iterator;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@IsSPIImplementation
public class UTF7CharsetProviderSPI
extends CharsetProvider {
    private static final String UTF7_NAME = "UTF-7";
    private static final String UTF7_O_NAME = "X-UTF-7-OPTIONAL";
    private static final String UTF7_M_NAME = "X-MODIFIED-UTF-7";
    private static final String[] UTF7_ALIASES = new String[]{"UNICODE-1-1-UTF-7", "CSUNICODE11UTF7", "X-RFC2152", "X-RFC-2152"};
    private static final String[] UTF7_O_ALIASES = new String[]{"X-RFC2152-OPTIONAL", "X-RFC-2152-OPTIONAL"};
    private static final String[] UTF7_M_ALIASES = new String[]{"X-IMAP-MODIFIED-UTF-7", "X-IMAP4-MODIFIED-UTF7", "X-IMAP4-MODIFIED-UTF-7", "X-RFC3501", "X-RFC-3501"};
    private static final Charset CHARSET_UTF7 = new UTF7Charset("UTF-7", UTF7_ALIASES, false);
    private static final Charset CHARSET_UTF7_O = new UTF7Charset("X-UTF-7-OPTIONAL", UTF7_O_ALIASES, true);
    private static final Charset CHARSET_UTF7_M = new UTF7CharsetModified("X-MODIFIED-UTF-7", UTF7_M_ALIASES);
    private final ICommonsList<Charset> m_aCharsets = new CommonsArrayList((Object[])new Charset[]{CHARSET_UTF7, CHARSET_UTF7_M, CHARSET_UTF7_O});

    @Override
    @Nullable
    public Charset charsetForName(@Nonnull String string) {
        String string2 = string.toUpperCase(Locale.US);
        for (Charset charset : this.m_aCharsets) {
            if (!charset.name().equals(string2)) continue;
            return charset;
        }
        for (Charset charset : this.m_aCharsets) {
            if (!charset.aliases().contains(string2)) continue;
            return charset;
        }
        return null;
    }

    @Override
    public Iterator<Charset> charsets() {
        return this.m_aCharsets.iterator();
    }
}

