/*
 * Decompiled with CFR 0.152.
 */
package com.helger.charset.utf7;

import com.helger.charset.utf7.AbstractUTF7StyleCharset;
import com.helger.commons.annotation.Nonempty;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

final class UTF7Charset
extends AbstractUTF7StyleCharset {
    private static final String BASE64_ALPHABET = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";
    private static final String SET_D = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789'(),-./:?";
    private static final String SET_OPTIONAL = "!\"#$%&*;<=>@[]^_`{|}";
    private static final String RULE_3 = " \t\r\n";
    private final String m_sDirectlyEncoded;

    UTF7Charset(@Nonnull @Nonempty String string, @Nullable String[] stringArray, boolean bl) {
        super(string, stringArray, BASE64_ALPHABET, false);
        this.m_sDirectlyEncoded = bl ? "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789'(),-./:?!\"#$%&*;<=>@[]^_`{|} \t\r\n" : "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789'(),-./:? \t\r\n";
    }

    @Override
    boolean canEncodeDirectly(char c) {
        return this.m_sDirectlyEncoded.indexOf(c) >= 0;
    }

    @Override
    byte shift() {
        return 43;
    }

    @Override
    byte unshift() {
        return 45;
    }
}

