/*
 * Decompiled with CFR 0.152.
 */
package com.helger.charset.utf7;

import com.helger.commons.annotation.Nonempty;
import java.util.Arrays;
import javax.annotation.Nonnull;

final class UTF7Base64Helper {
    private static final int ALPHABET_LENGTH = 64;
    private final char[] m_aAlphabet;
    private final int[] m_aInverseAlphabet;

    UTF7Base64Helper(@Nonnull @Nonempty String string) {
        this.m_aAlphabet = string.toCharArray();
        if (string.length() != 64) {
            throw new IllegalArgumentException("alphabet has incorrect length (should be 64, not " + string.length() + ")");
        }
        this.m_aInverseAlphabet = new int[128];
        Arrays.fill(this.m_aInverseAlphabet, -1);
        int n = 0;
        while (n < this.m_aAlphabet.length) {
            char c = this.m_aAlphabet[n];
            if (c >= '\u0080') {
                throw new IllegalArgumentException("invalid character in alphabet: " + c);
            }
            this.m_aInverseAlphabet[c] = n++;
        }
    }

    int getSextet(int n) {
        if (n >= 128) {
            return -1;
        }
        return this.m_aInverseAlphabet[n];
    }

    boolean contains(char c) {
        if (c >= '\u0080') {
            return false;
        }
        return this.m_aInverseAlphabet[c] >= 0;
    }

    byte getChar(int n) {
        return (byte)this.m_aAlphabet[n];
    }
}

