/*
 * Decompiled with CFR 0.152.
 */
package com.helger.charset.utf7;

import com.helger.charset.utf7.UTF7Base64Helper;
import com.helger.charset.utf7.UTF7StyleCharsetDecoder;
import com.helger.charset.utf7.UTF7StyleCharsetEncoder;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.collection.ext.CommonsArrayList;
import com.helger.commons.collection.ext.ICommonsList;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class AbstractUTF7StyleCharset
extends Charset {
    private static final ICommonsList<String> CONTAINED = new CommonsArrayList((Object[])new String[]{"US-ASCII", "ISO-8859-1", "UTF-8", "UTF-16", "UTF-16LE", "UTF-16BE"});
    private final boolean m_bStrict;
    private final UTF7Base64Helper m_aBase64;

    protected AbstractUTF7StyleCharset(@Nonnull @Nonempty String string, @Nullable String[] stringArray, @Nonnull @Nonempty String string2, boolean bl) {
        super(string, stringArray);
        this.m_aBase64 = new UTF7Base64Helper(string2);
        this.m_bStrict = bl;
    }

    @Override
    public boolean contains(@Nonnull Charset charset) {
        return CONTAINED.contains((Object)charset.name());
    }

    @Override
    public CharsetDecoder newDecoder() {
        return new UTF7StyleCharsetDecoder(this, this.m_aBase64, this.m_bStrict);
    }

    @Override
    public CharsetEncoder newEncoder() {
        return new UTF7StyleCharsetEncoder(this, this.m_aBase64, this.m_bStrict);
    }

    abstract boolean canEncodeDirectly(char var1);

    abstract byte shift();

    abstract byte unshift();
}

