/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.jaxws;

import java.io.File;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.codehaus.mojo.jaxws.AbstractWsGenMojo;

@Mojo(name="wsgen-test", defaultPhase=LifecyclePhase.PROCESS_TEST_CLASSES, requiresDependencyResolution=ResolutionScope.TEST, threadSafe=true)
public class TestWsGenMojo
extends AbstractWsGenMojo {
    @Parameter(defaultValue="${project.build.testOutputDirectory}")
    private File destDir;
    @Parameter(defaultValue="${project.build.directory}/generated-sources/test-wsgen")
    private File sourceDestDir;
    @Parameter(defaultValue="${project.build.directory}/generated-sources/test-wsdl")
    private File resourceDestDir;
    @Parameter(property="maven.test.skip")
    private boolean skip;

    @Override
    protected File getDestDir() {
        return this.destDir;
    }

    @Override
    protected File getSourceDestDir() {
        return this.sourceDestDir;
    }

    @Override
    protected void addSourceRoot(String string) {
        if (!this.project.getTestCompileSourceRoots().contains(string)) {
            this.getLog().debug((CharSequence)("adding test src root: " + string));
            this.project.addTestCompileSourceRoot(string);
        } else {
            this.getLog().debug((CharSequence)("existing test src root: " + string));
        }
    }

    @Override
    protected File getResourceDestDir() {
        return this.resourceDestDir;
    }

    @Override
    protected File getDefaultSrcOut() {
        return new File(this.project.getBuild().getDirectory(), "generated-sources/test-wsgen");
    }

    @Override
    protected File getClassesDir() {
        return new File(this.project.getBuild().getTestOutputDirectory());
    }

    @Override
    protected String getExtraClasspath() {
        String string = super.getExtraClasspath();
        StringBuilder stringBuilder = new StringBuilder();
        int n = string.indexOf(File.pathSeparatorChar);
        stringBuilder.append(n > 0 ? string.substring(0, n) : string);
        stringBuilder.append(File.pathSeparatorChar);
        stringBuilder.append(this.project.getBuild().getOutputDirectory());
        if (n > 0 && string.substring(n).length() > 0) {
            stringBuilder.append(string.substring(n));
        }
        return stringBuilder.toString();
    }

    @Override
    public void executeJaxws() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipping tests, nothing to do.");
        } else {
            super.executeJaxws();
        }
    }
}

