/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.jaxws;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.settings.Proxy;
import org.apache.maven.settings.Settings;
import org.codehaus.mojo.jaxws.AbstractJaxwsMojo;

abstract class WsImportMojo
extends AbstractJaxwsMojo {
    private static final String STALE_FILE_PREFIX = ".";
    private static final String PATTERN = "[^\\s]+\\.wsdl$";
    @Parameter
    private String packageName;
    @Parameter
    private File catalog;
    @Parameter
    private String httpproxy;
    @Parameter(defaultValue="${project.basedir}/src/wsdl")
    private File wsdlDirectory;
    @Parameter
    protected List<String> wsdlFiles;
    @Parameter
    private List<?> wsdlUrls;
    @Parameter(defaultValue="${project.basedir}/src/jaxws")
    protected File bindingDirectory;
    @Parameter
    protected List<String> bindingFiles;
    @Parameter
    private String wsdlLocation;
    @Parameter
    private String target;
    @Parameter(defaultValue="false")
    private boolean quiet;
    @Parameter
    private String implServiceName;
    @Parameter
    private String implPortName;
    @Parameter(defaultValue="false")
    private boolean genJWS;
    @Parameter(defaultValue="true")
    private boolean xnocompile;
    @Parameter(defaultValue="false")
    private boolean xadditionalHeaders;
    @Parameter(defaultValue="false")
    private boolean xdebug;
    @Parameter(defaultValue="false")
    private boolean xnoAddressingDataBinding;
    @Parameter
    protected File xauthFile;
    @Parameter(defaultValue="false")
    private boolean xdisableSSLHostnameVerification;
    @Parameter(defaultValue="false")
    private boolean xuseBaseResourceAndURLToLoadWSDL;
    @Parameter(defaultValue="false")
    private boolean xdisableAuthenticator;
    @Parameter
    private List<String> xjcArgs;
    @Parameter(defaultValue="${project.build.directory}/jaxws/stale")
    private File staleFile;
    @Parameter(defaultValue="${settings}", readonly=true, required=true)
    private Settings settings;
    private static final FileFilter XML_FILE_FILTER = file -> file.getName().endsWith(".xml");
    private static final FileFilter WSDL_FILE_FILTER = file -> file.getName().endsWith(".wsdl");

    WsImportMojo() {
    }

    protected abstract File getImplDestDir();

    protected abstract List<String> getWSDLFileLookupClasspathElements();

    @Override
    public void executeJaxws() throws MojoExecutionException {
        try {
            URL[] uRLArray = this.getWSDLFiles();
            if (uRLArray.length == 0 && (this.wsdlUrls == null || this.wsdlUrls.isEmpty())) {
                this.getLog().info((CharSequence)"No WSDLs are found to process, Specify at least one of the following parameters: wsdlFiles, wsdlDirectory or wsdlUrls.");
                return;
            }
            this.processWsdlViaUrls();
            this.processLocalWsdlFiles(uRLArray);
        }
        catch (MojoExecutionException mojoExecutionException) {
            throw mojoExecutionException;
        }
        catch (IOException iOException) {
            throw new MojoExecutionException(iOException.getMessage(), (Exception)iOException);
        }
    }

    @Override
    protected String getMain() {
        return "com.sun.tools.ws.wscompile.WsimportTool";
    }

    @Override
    protected String getToolName() {
        return "wsimport";
    }

    @Override
    protected boolean isXnocompile() {
        return this.xnocompile;
    }

    private void processLocalWsdlFiles(URL[] uRLArray) throws MojoExecutionException, IOException {
        for (URL uRL : uRLArray) {
            String string = uRL.toExternalForm();
            if (this.isOutputStale(string)) {
                this.getLog().info((CharSequence)("Processing: " + string));
                String string2 = null;
                if ("file".equals(uRL.getProtocol())) {
                    string2 = this.getRelativePath(new File(uRL.getPath()));
                }
                ArrayList<String> arrayList = this.getWsImportArgs(string2);
                arrayList.add("\"" + string + "\"");
                this.getLog().info((CharSequence)("jaxws:wsimport args: " + arrayList));
                this.exec(arrayList);
                this.touchStaleFile(string);
            } else {
                this.getLog().info((CharSequence)("Ignoring: " + string));
            }
            this.addSourceRoot(this.getSourceDestDir().getAbsolutePath());
        }
    }

    private void processWsdlViaUrls() throws MojoExecutionException, IOException {
        for (int i = 0; this.wsdlUrls != null && i < this.wsdlUrls.size(); ++i) {
            String string = this.wsdlUrls.get(i).toString();
            if (this.isOutputStale(string)) {
                this.getLog().info((CharSequence)("Processing: " + string));
                ArrayList<String> arrayList = this.getWsImportArgs(null);
                arrayList.add("\"" + string + "\"");
                this.getLog().info((CharSequence)("jaxws:wsimport args: " + arrayList));
                this.exec(arrayList);
                this.touchStaleFile(string);
            }
            this.addSourceRoot(this.getSourceDestDir().getAbsolutePath());
        }
    }

    private ArrayList<String> getWsImportArgs(String string) throws MojoExecutionException {
        Object object;
        Object object2;
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.addAll(this.getCommonArgs());
        if (this.httpproxy != null) {
            arrayList.add("-httpproxy:" + this.httpproxy);
        } else if (this.settings != null) {
            object2 = WsImportMojo.getActiveHttpProxy(this.settings);
            if (object2 != null) {
                arrayList.add("-httpproxy:" + (String)object2);
            }
            if ((object = WsImportMojo.getActiveNonProxyHosts(this.settings)) != null) {
                this.addVmArg("-Dhttp.nonProxyHosts=\"" + (String)object + "\"");
            }
        }
        if (this.packageName != null) {
            arrayList.add("-p");
            arrayList.add(this.packageName);
        }
        if (this.catalog != null) {
            arrayList.add("-catalog");
            arrayList.add("'" + this.catalog.getAbsolutePath() + "'");
        }
        if (this.wsdlLocation != null) {
            if (string != null) {
                arrayList.add("-wsdllocation");
                arrayList.add(this.wsdlLocation.replaceAll("\\*", string));
            } else if (!this.wsdlLocation.contains("*")) {
                arrayList.add("-wsdllocation");
                arrayList.add(this.wsdlLocation);
            }
        }
        if (this.target != null) {
            arrayList.add("-target");
            arrayList.add(this.target);
        }
        if (this.quiet) {
            arrayList.add("-quiet");
        }
        if ((this.genJWS || this.implServiceName != null || this.implPortName != null) && this.isArgSupported("-generateJWS")) {
            arrayList.add("-generateJWS");
            if (this.implServiceName != null && this.isArgSupported("-implServiceName")) {
                arrayList.add("-implServiceName");
                arrayList.add(this.implServiceName);
            }
            if (this.implPortName != null && this.isArgSupported("-implPortName")) {
                arrayList.add("-implPortName");
                arrayList.add(this.implPortName);
            }
            if (!((File)(object2 = this.getImplDestDir())).mkdirs() && !((File)object2).exists()) {
                this.getLog().warn((CharSequence)("Cannot create directory: " + ((File)object2).getAbsolutePath()));
            }
            arrayList.add("-implDestDir");
            arrayList.add("'" + ((File)object2).getAbsolutePath() + "'");
            if (!this.project.getCompileSourceRoots().contains(((File)object2).getAbsolutePath())) {
                this.project.addCompileSourceRoot(((File)object2).getAbsolutePath());
            }
        }
        if (this.xdebug) {
            arrayList.add("-Xdebug");
        }
        if (this.xnoAddressingDataBinding) {
            arrayList.add("-Xno-addressing-databinding");
        }
        if (this.xadditionalHeaders) {
            arrayList.add("-XadditionalHeaders");
        }
        if (this.xauthFile != null) {
            arrayList.add("-Xauthfile");
            arrayList.add(this.xauthFile.getAbsolutePath());
        }
        if (this.xdisableSSLHostnameVerification) {
            arrayList.add("-XdisableSSLHostnameVerification");
        }
        if (this.xuseBaseResourceAndURLToLoadWSDL) {
            arrayList.add("-XuseBaseResourceAndURLToLoadWSDL");
        }
        if (this.xdisableAuthenticator && this.isArgSupported("-XdisableAuthenticator")) {
            arrayList.add("-XdisableAuthenticator");
        }
        if (this.xjcArgs != null) {
            object2 = this.xjcArgs.iterator();
            while (object2.hasNext()) {
                object = (String)object2.next();
                if (((String)object).startsWith("-")) {
                    arrayList.add("-B" + (String)object);
                    continue;
                }
                arrayList.add((String)object);
            }
        }
        if (((File[])(object2 = this.getBindingFiles())).length > 0 && this.wsdlLocation != null && this.wsdlLocation.contains("*")) {
            throw new MojoExecutionException("External binding file(s) can not be bound to more WSDL files (" + this.wsdlLocation + ")\nPlease use either inline binding(s) or multiple execution tags.");
        }
        for (Object object3 : object2) {
            arrayList.add("-b");
            arrayList.add("'" + ((File)object3).toURI() + "'");
        }
        return arrayList;
    }

    public final File[] getBindingFiles() {
        File[] fileArray;
        if (this.bindingFiles != null) {
            fileArray = new File[this.bindingFiles.size()];
            for (int i = 0; i < this.bindingFiles.size(); ++i) {
                String string = this.bindingFiles.get(i);
                File file = new File(string);
                if (!file.isAbsolute()) {
                    file = new File(this.bindingDirectory, string);
                }
                fileArray[i] = file;
            }
        } else {
            this.getLog().debug((CharSequence)("The binding Directory is " + this.bindingDirectory));
            fileArray = this.bindingDirectory.listFiles(XML_FILE_FILTER);
            if (fileArray == null) {
                fileArray = new File[]{};
            }
        }
        return fileArray;
    }

    private URL[] getWSDLFiles() throws MojoExecutionException {
        ArrayList<URL> arrayList;
        block45: {
            Object throwable;
            arrayList = new ArrayList<URL>();
            List<String> list = this.getWSDLFileLookupClasspathElements();
            ArrayList<URL> arrayList2 = new ArrayList<URL>(list.size());
            for (String object2 : list) {
                try {
                    throwable = new File(object2).toURI().toURL();
                    arrayList2.add((URL)throwable);
                }
                catch (MalformedURLException throwable2) {
                    throw new MojoExecutionException("Error while retrieving list of WSDL files to process", (Exception)throwable2);
                }
            }
            try {
                Throwable throwable3 = null;
                try (URLClassLoader uRLClassLoader = new URLClassLoader(arrayList2.toArray(new URL[0]));){
                    if (this.wsdlFiles != null) {
                        for (String string : this.wsdlFiles) {
                            File uRL = new File(string);
                            URL string2 = null;
                            if (!uRL.isAbsolute()) {
                                uRL = new File(this.wsdlDirectory, string);
                            }
                            if (!uRL.exists()) {
                                string2 = uRLClassLoader.getResource(string);
                            } else {
                                try {
                                    string2 = uRL.toURI().toURL();
                                }
                                catch (MalformedURLException pattern) {
                                    this.getLog().error((Throwable)pattern);
                                }
                            }
                            this.getLog().debug((CharSequence)("The wsdl File is '" + string + "' from '" + string2 + "'"));
                            if (string2 != null) {
                                arrayList.add(string2);
                                continue;
                            }
                            throw new MojoExecutionException("'" + string + "' not found.");
                        }
                        break block45;
                    }
                    this.getLog().debug((CharSequence)("The wsdl Directory is " + this.wsdlDirectory));
                    if (this.wsdlDirectory.exists()) {
                        throwable = this.wsdlDirectory.listFiles(WSDL_FILE_FILTER);
                        for (File file : throwable) {
                            arrayList.add(file.toURI().toURL());
                        }
                        break block45;
                    }
                    throwable = this.project.getBasedir().toURI().relativize(this.wsdlDirectory.toURI());
                    String string = ((URI)throwable).getPath();
                    URL uRL = uRLClassLoader.getResource(string);
                    if (uRL == null) {
                        string = "WEB-INF/wsdl/";
                        uRL = uRLClassLoader.getResource(string);
                    }
                    if (uRL == null) {
                        string = "META-INF/wsdl/";
                        uRL = uRLClassLoader.getResource(string);
                    }
                    if (uRL == null || !"jar".equalsIgnoreCase(uRL.getProtocol())) break block45;
                    String string2 = uRL.getPath();
                    Pattern pattern = Pattern.compile(string.replace(File.separatorChar, '/') + PATTERN, 2);
                    try (JarFile jarFile = new JarFile(string2.substring(5, string2.indexOf("!/")));){
                        Enumeration<JarEntry> enumeration = jarFile.entries();
                        while (enumeration.hasMoreElements()) {
                            JarEntry jarEntry = enumeration.nextElement();
                            Matcher matcher = pattern.matcher(jarEntry.getName());
                            if (!matcher.matches()) continue;
                            String string3 = "jar:" + string2.substring(0, string2.indexOf("!/") + 2) + jarEntry.getName();
                            arrayList.add(new URL(string3));
                        }
                    }
                    catch (IOException iOException) {
                        this.getLog().error((Throwable)iOException);
                    }
                }
                catch (Throwable throwable4) {
                    Throwable throwable5 = throwable4;
                    throw throwable4;
                }
            }
            catch (MojoExecutionException mojoExecutionException) {
                throw mojoExecutionException;
            }
            catch (Exception exception) {
                throw new MojoExecutionException("Error while retrieving list of WSDL files to process", exception);
            }
        }
        return arrayList.toArray(new URL[0]);
    }

    private String getRelativePath(File file) {
        block3: {
            File[] fileArray;
            block2: {
                if (this.wsdlFiles == null) break block2;
                for (String string : this.wsdlFiles) {
                    String string2 = file.getPath().replace(File.separatorChar, '/');
                    if (!string2.endsWith(string) || string2.length() == string.length()) continue;
                    return string;
                }
                break block3;
            }
            if (this.wsdlDirectory == null || !this.wsdlDirectory.exists()) break block3;
            for (File file2 : fileArray = this.wsdlDirectory.listFiles(WSDL_FILE_FILTER)) {
                String string = file.getPath().replace(File.separatorChar, '/');
                if (!string.endsWith(file2.getName())) continue;
                return file2.getName();
            }
        }
        return null;
    }

    private boolean isOutputStale(String string) {
        boolean bl;
        File[] fileArray = this.getBindingFiles();
        File file = new File(this.staleFile, STALE_FILE_PREFIX + this.getHash(string));
        boolean bl2 = bl = !file.exists();
        if (!bl) {
            this.getLog().debug((CharSequence)"Stale flag file exists, comparing to wsdls and bindings.");
            long l = file.lastModified();
            try {
                File[] fileArray2 = new URL(string);
                if (fileArray2.openConnection().getLastModified() > l) {
                    this.getLog().debug((CharSequence)(string + " is newer than the stale flag file."));
                    bl = true;
                }
            }
            catch (MalformedURLException malformedURLException) {
                File file2 = new File(string);
                if (file2.lastModified() > l) {
                    this.getLog().debug((CharSequence)(string + " is newer than the stale flag file."));
                    bl = true;
                }
            }
            catch (IOException iOException) {
                this.getLog().error((Throwable)iOException);
            }
            for (File file3 : fileArray) {
                if (file3.lastModified() <= l) continue;
                this.getLog().debug((CharSequence)(file3.getName() + " is newer than the stale flag file."));
                bl = true;
            }
        }
        return bl;
    }

    private void touchStaleFile(String string) throws IOException {
        File file = new File(this.staleFile, STALE_FILE_PREFIX + this.getHash(string));
        if (!file.exists()) {
            File file2 = file.getParentFile();
            if (!file2.mkdirs() && !file2.exists()) {
                this.getLog().warn((CharSequence)("Cannot create directory: " + file2.getAbsolutePath()));
            }
            if (!file.createNewFile()) {
                this.getLog().warn((CharSequence)("Cannot create file: " + file.getAbsolutePath()));
            }
            this.getLog().debug((CharSequence)("Stale flag file created.[" + file.getAbsolutePath() + "]"));
        } else if (!file.setLastModified(System.currentTimeMillis())) {
            this.getLog().warn((CharSequence)"Stale file has not been updated!");
        }
    }

    private String getHash(String string) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA");
            byte[] byArray = messageDigest.digest(string.getBytes(StandardCharsets.UTF_8));
            StringBuilder stringBuilder = new StringBuilder(byArray.length * 2);
            for (byte by : byArray) {
                stringBuilder.append(Character.forDigit((by & 0xF0) >> 4, 16)).append(Character.forDigit(by & 0xF, 16));
            }
            return stringBuilder.toString();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            this.getLog().debug((CharSequence)noSuchAlgorithmException.getMessage(), (Throwable)noSuchAlgorithmException);
            this.getLog().warn((CharSequence)("Could not compute hash for " + string + ". Using fallback method."));
            return string.substring(string.lastIndexOf(47)).replaceAll("\\.", "-");
        }
    }

    static String getActiveHttpProxy(Settings settings) {
        String string = null;
        for (Proxy proxy : settings.getProxies()) {
            if (!proxy.isActive() || !"http".equals(proxy.getProtocol())) continue;
            StringBuilder stringBuilder = new StringBuilder();
            String string2 = proxy.getUsername();
            String string3 = proxy.getPassword();
            if (string2 != null) {
                stringBuilder.append(string2);
                if (string3 != null) {
                    stringBuilder.append(":");
                    stringBuilder.append(string3);
                }
                stringBuilder.append("@");
            }
            stringBuilder.append(proxy.getHost());
            stringBuilder.append(":");
            stringBuilder.append(proxy.getPort());
            string = stringBuilder.toString().trim();
            break;
        }
        return string;
    }

    static String getActiveNonProxyHosts(Settings settings) {
        String string = null;
        for (Proxy proxy : settings.getProxies()) {
            if (!proxy.isActive() || !"http".equals(proxy.getProtocol())) continue;
            string = proxy.getNonProxyHosts();
            break;
        }
        return string;
    }
}

