/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.jaxws;

import java.io.File;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.codehaus.mojo.jaxws.WsImportMojo;

@Mojo(name="wsimport-test", defaultPhase=LifecyclePhase.GENERATE_TEST_SOURCES, requiresDependencyResolution=ResolutionScope.TEST, threadSafe=true)
public class TestWsImportMojo
extends WsImportMojo {
    @Parameter(defaultValue="${project.build.testOutputDirectory}")
    private File destDir;
    @Parameter(defaultValue="${project.build.directory}/generated-sources/test-wsimport")
    private File sourceDestDir;
    @Parameter(defaultValue="${project.build.testSourceDirectory}")
    private File implDestDir;
    @Parameter(property="maven.test.skip")
    private boolean skip;

    @Override
    protected File getDestDir() {
        return this.destDir;
    }

    @Override
    protected File getSourceDestDir() {
        return this.sourceDestDir;
    }

    @Override
    protected void addSourceRoot(String string) {
        if (!this.project.getTestCompileSourceRoots().contains(string)) {
            this.getLog().debug((CharSequence)("adding test src root: " + string));
            this.project.addTestCompileSourceRoot(string);
        } else {
            this.getLog().debug((CharSequence)("existing test src root: " + string));
        }
    }

    @Override
    protected File getDefaultSrcOut() {
        return new File(this.project.getBuild().getDirectory(), "generated-sources/test-wsimport");
    }

    @Override
    protected File getImplDestDir() {
        return this.implDestDir;
    }

    @Override
    protected List<String> getWSDLFileLookupClasspathElements() {
        return this.project.getDependencyArtifacts().stream().filter(artifact -> !"runtime".equals(artifact.getScope()) && null != artifact.getFile()).map(artifact -> artifact.getFile().getPath()).collect(Collectors.toList());
    }

    @Override
    public void executeJaxws() throws MojoExecutionException {
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipping tests, nothing to do.");
        } else {
            super.executeJaxws();
        }
    }
}

