/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.jaxws;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import javax.jws.WebService;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.mojo.jaxws.AbstractJaxwsMojo;
import org.codehaus.plexus.util.FileUtils;

abstract class AbstractWsGenMojo
extends AbstractJaxwsMojo {
    @Parameter(defaultValue="false")
    protected boolean genWsdl;
    @Parameter
    private String sei;
    @Parameter
    private String protocol;
    @Parameter
    private String servicename;
    @Parameter
    private String portname;
    @Parameter(defaultValue="false")
    private boolean inlineSchemas;
    @Parameter(defaultValue="false")
    private boolean xnocompile;
    @Parameter(defaultValue="false")
    private boolean xdonotoverwrite;
    @Parameter
    private File metadata;

    AbstractWsGenMojo() {
    }

    protected abstract File getResourceDestDir();

    protected abstract File getClassesDir();

    @Override
    public void executeJaxws() throws MojoExecutionException, MojoFailureException {
        HashSet<String> hashSet = new HashSet<String>();
        if (this.sei != null) {
            hashSet.add(this.sei);
        } else {
            hashSet.addAll(this.getSEIs(this.getClassesDir()));
        }
        if (hashSet.isEmpty()) {
            throw new MojoFailureException("No @javax.jws.WebService found.");
        }
        for (String string : hashSet) {
            this.processSei(string);
        }
    }

    protected void processSei(String string) throws MojoExecutionException {
        this.getLog().info((CharSequence)("Processing: " + string));
        ArrayList<String> arrayList = this.getWsGenArgs(string);
        this.getLog().info((CharSequence)("jaxws:wsgen args: " + arrayList));
        this.exec(arrayList);
        if (this.metadata != null) {
            try {
                FileUtils.copyFileToDirectory((File)this.metadata, (File)this.getClassesDir());
            }
            catch (IOException iOException) {
                throw new MojoExecutionException(iOException.getMessage(), (Exception)iOException);
            }
        }
    }

    @Override
    protected String getMain() {
        return "com.sun.tools.ws.wscompile.WsgenTool";
    }

    @Override
    protected String getToolName() {
        return "wsgen";
    }

    @Override
    protected String getExtraClasspath() {
        return String.join((CharSequence)File.pathSeparator, this.getClassesDir().getAbsolutePath(), AbstractWsGenMojo.getCPasString(this.project.getArtifacts()));
    }

    @Override
    protected boolean isXnocompile() {
        return this.xnocompile;
    }

    private ArrayList<String> getWsGenArgs(String string) throws MojoExecutionException {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.addAll(this.getCommonArgs());
        if (this.genWsdl) {
            File file;
            if (this.protocol != null) {
                arrayList.add("-wsdl:" + this.protocol);
            } else {
                arrayList.add("-wsdl");
            }
            if (this.inlineSchemas) {
                this.maybeUnsupportedOption("-inlineSchemas", null, arrayList);
            }
            if (this.servicename != null) {
                arrayList.add("-servicename");
                arrayList.add(this.servicename);
            }
            if (this.portname != null) {
                arrayList.add("-portname");
                arrayList.add(this.portname);
            }
            if (!(file = this.getResourceDestDir()).mkdirs() && !file.exists()) {
                this.getLog().warn((CharSequence)("Cannot create directory: " + file.getAbsolutePath()));
            }
            arrayList.add("-r");
            arrayList.add("'" + file.getAbsolutePath() + "'");
            if (!"war".equals(this.project.getPackaging())) {
                Resource resource = new Resource();
                resource.setDirectory(this.getRelativePath(this.project.getBasedir(), this.getResourceDestDir()));
                this.project.addResource(resource);
            }
        }
        if (this.xdonotoverwrite) {
            arrayList.add("-Xdonotoverwrite");
        }
        if (this.metadata != null && this.isArgSupported("-x")) {
            this.maybeUnsupportedOption("-x", "'" + this.metadata.getAbsolutePath() + "'", arrayList);
        }
        arrayList.add(string);
        return arrayList;
    }

    private String getRelativePath(File file, File file2) {
        return file.toURI().relativize(file2.toURI()).getPath();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Set<String> getSEIs(File file) throws MojoExecutionException {
        HashSet<String> hashSet = new HashSet<String>();
        if (!file.exists() || file.isFile()) {
            return hashSet;
        }
        try (URLClassLoader uRLClassLoader = new URLClassLoader(new URL[]{file.toURI().toURL()}, ((Object)((Object)this)).getClass().getClassLoader());){
            for (String string : FileUtils.getFileAndDirectoryNames((File)file, (String)"**/*.class", null, (boolean)false, (boolean)true, (boolean)true, (boolean)false)) {
                try {
                    String string2 = string.replace(File.separator, ".");
                    Class<?> clazz = uRLClassLoader.loadClass(string2.substring(0, string2.length() - 6));
                    WebService webService = clazz.getAnnotation(WebService.class);
                    if (clazz.isInterface() || webService == null) continue;
                    hashSet.add(clazz.getName());
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new MojoExecutionException(classNotFoundException.getMessage(), (Exception)classNotFoundException);
                    return hashSet;
                }
            }
        }
        catch (IOException iOException) {
            throw new MojoExecutionException(iOException.getMessage(), (Exception)iOException);
        }
    }
}

