/*
 * Decompiled with CFR 0.152.
 */
package com.helger.jcodemodel.fmt;

import com.helger.jcodemodel.AbstractJResourceFile;
import com.helger.jcodemodel.util.JCValueEnforcer;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.WillNotClose;

public class JTextFile
extends AbstractJResourceFile {
    private String m_sContents;
    private final Charset m_aEncoding;

    public JTextFile(@Nonnull String string, @Nonnull Charset charset) {
        super(string);
        this.m_aEncoding = JCValueEnforcer.notNull(charset, "Encoding");
    }

    public void setContents(@Nullable String string) {
        this.m_sContents = string;
    }

    @Nullable
    public String contents() {
        return this.m_sContents;
    }

    @Nonnull
    public Charset encoding() {
        return this.m_aEncoding;
    }

    @Override
    public void build(@Nonnull @WillNotClose OutputStream outputStream) throws IOException {
        if (this.m_sContents != null) {
            try (OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, this.m_aEncoding){

                @Override
                public void close() {
                }
            };){
                outputStreamWriter.write(this.m_sContents);
            }
        }
    }
}

