/*
 * Decompiled with CFR 0.152.
 */
package com.helger.jcodemodel;

import com.helger.jcodemodel.AbstractJClass;
import com.helger.jcodemodel.IJExpression;
import com.helger.jcodemodel.JFormatter;
import com.helger.jcodemodel.util.JCEqualsHelper;
import com.helger.jcodemodel.util.JCHashCodeGenerator;
import com.helger.jcodemodel.util.JCValueEnforcer;
import javax.annotation.Nonnull;

public class JEnumConstantRef
implements IJExpression {
    private final AbstractJClass m_aType;
    private final String m_sName;

    protected JEnumConstantRef(@Nonnull AbstractJClass abstractJClass, @Nonnull String string) {
        JCValueEnforcer.notNull(abstractJClass, "Type");
        JCValueEnforcer.notNull(string, "Name");
        this.m_aType = abstractJClass;
        this.m_sName = string;
    }

    @Nonnull
    public AbstractJClass type() {
        return this.m_aType;
    }

    @Nonnull
    public String name() {
        return this.m_sName;
    }

    @Nonnull
    public String getName() {
        return this.m_aType.fullName() + '.' + this.m_sName;
    }

    @Override
    public void generate(@Nonnull JFormatter jFormatter) {
        jFormatter.type(this.m_aType).print('.').print(this.m_sName);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        JEnumConstantRef jEnumConstantRef = (JEnumConstantRef)object;
        return JCEqualsHelper.isEqual(this.m_aType.fullName(), jEnumConstantRef.m_aType.fullName()) && JCEqualsHelper.isEqual(this.m_sName, jEnumConstantRef.m_sName);
    }

    public int hashCode() {
        return JCHashCodeGenerator.getHashCode(this, this.m_aType.fullName(), this.m_sName);
    }
}

