/*
 * Decompiled with CFR 0.152.
 */
package com.helger.jcodemodel;

import com.helger.jcodemodel.AbstractJType;
import com.helger.jcodemodel.IJExpression;
import com.helger.jcodemodel.JFormatter;
import com.helger.jcodemodel.util.JCEqualsHelper;
import com.helger.jcodemodel.util.JCHashCodeGenerator;
import javax.annotation.Nonnull;

public class JCast
implements IJExpression {
    private final AbstractJType m_aType;
    private final IJExpression m_aObject;

    protected JCast(@Nonnull AbstractJType abstractJType, @Nonnull IJExpression iJExpression) {
        this.m_aType = abstractJType;
        this.m_aObject = iJExpression;
    }

    @Nonnull
    public AbstractJType type() {
        return this.m_aType;
    }

    @Nonnull
    public IJExpression object() {
        return this.m_aObject;
    }

    @Override
    public void generate(@Nonnull JFormatter jFormatter) {
        jFormatter.print("((").generable(this.m_aType).print(')').generable(this.m_aObject).print(')');
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        JCast jCast = (JCast)object;
        return JCEqualsHelper.isEqual(this.m_aType.fullName(), jCast.m_aType.fullName()) && JCEqualsHelper.isEqual(this.m_aObject, jCast.m_aObject);
    }

    public int hashCode() {
        return JCHashCodeGenerator.getHashCode(this, this.m_aType.fullName(), this.m_aObject);
    }
}

