/*
 * Decompiled with CFR 0.152.
 */
package com.helger.xml.xpath;

import com.helger.annotation.Nonnegative;
import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.clone.ICloneable;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.equals.EqualsHelper;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.state.EChange;
import com.helger.base.state.IChangeIndicator;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.collection.commons.CommonsHashMap;
import com.helger.collection.commons.ICommonsMap;
import com.helger.xml.xpath.MapBasedXPathVariableResolverQName;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPathVariableResolver;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@NotThreadSafe
public class MapBasedXPathVariableResolver
implements XPathVariableResolver,
ICloneable<MapBasedXPathVariableResolver> {
    private final ICommonsMap<String, Object> m_aMap;

    public MapBasedXPathVariableResolver() {
        this((Map)null);
    }

    public MapBasedXPathVariableResolver(@Nullable Map<String, ?> map) {
        this.m_aMap = new CommonsHashMap(map);
    }

    public MapBasedXPathVariableResolver(@NonNull MapBasedXPathVariableResolver mapBasedXPathVariableResolver) {
        ValueEnforcer.notNull((Object)mapBasedXPathVariableResolver, (String)"Other");
        this.m_aMap = (ICommonsMap)mapBasedXPathVariableResolver.m_aMap.getClone();
    }

    public @NonNull EChange addUniqueVariable(@NonNull String string, @NonNull Object object) {
        ValueEnforcer.notNull((Object)string, (String)"Name");
        ValueEnforcer.notNull((Object)object, (String)"Value");
        if (this.m_aMap.containsKey((Object)string)) {
            return EChange.UNCHANGED;
        }
        this.m_aMap.put((Object)string, object);
        return EChange.CHANGED;
    }

    public @NonNull EChange addAllFrom(@NonNull MapBasedXPathVariableResolver mapBasedXPathVariableResolver, boolean bl) {
        ValueEnforcer.notNull((Object)mapBasedXPathVariableResolver, (String)"Other");
        EChange eChange = EChange.UNCHANGED;
        for (Map.Entry entry : mapBasedXPathVariableResolver.m_aMap.entrySet()) {
            if (!bl && this.m_aMap.containsKey(entry.getKey())) continue;
            this.m_aMap.put((Object)((String)entry.getKey()), entry.getValue());
            eChange = EChange.CHANGED;
        }
        return eChange;
    }

    public @NonNull EChange addAllFrom(@NonNull MapBasedXPathVariableResolverQName mapBasedXPathVariableResolverQName, boolean bl) {
        ValueEnforcer.notNull((Object)mapBasedXPathVariableResolverQName, (String)"Other");
        EChange eChange = EChange.UNCHANGED;
        for (Map.Entry entry : mapBasedXPathVariableResolverQName.getAllVariables().entrySet()) {
            String string = ((QName)entry.getKey()).getLocalPart();
            if (!bl && this.m_aMap.containsKey((Object)string)) continue;
            this.m_aMap.put((Object)string, entry.getValue());
            eChange = EChange.CHANGED;
        }
        return eChange;
    }

    public @NonNull EChange removeVariable(@Nullable String string) {
        if (string == null) {
            return EChange.UNCHANGED;
        }
        return this.m_aMap.removeObject((Object)string);
    }

    public @NonNull EChange removeVariables(@Nullable Iterable<String> iterable) {
        EChange eChange = EChange.UNCHANGED;
        if (iterable != null) {
            for (String string : iterable) {
                eChange = eChange.or((IChangeIndicator)this.removeVariable(string));
            }
        }
        return eChange;
    }

    @ReturnsMutableCopy
    public @NonNull ICommonsMap<String, ?> getAllVariables() {
        return (ICommonsMap)this.m_aMap.getClone();
    }

    @Nonnegative
    public int getVariableCount() {
        return this.m_aMap.size();
    }

    public @NonNull EChange clear() {
        return this.m_aMap.removeAll();
    }

    public void setAllVariables(@Nullable Map<String, ?> map) {
        this.m_aMap.setAll(map);
    }

    @Override
    public @Nullable Object resolveVariable(@NonNull QName qName) {
        ValueEnforcer.notNull((Object)qName, (String)"VariableName");
        String string = qName.getLocalPart();
        return this.m_aMap.get((Object)string);
    }

    @ReturnsMutableCopy
    public @NonNull MapBasedXPathVariableResolver getClone() {
        return new MapBasedXPathVariableResolver(this);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        MapBasedXPathVariableResolver mapBasedXPathVariableResolver = (MapBasedXPathVariableResolver)object;
        return EqualsHelper.equals(this.m_aMap, mapBasedXPathVariableResolver.m_aMap);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append(this.m_aMap).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("map", this.m_aMap).getToString();
    }
}

