/*
 * Decompiled with CFR 0.152.
 */
package com.helger.xml.transform;

import com.helger.base.location.ILocation;
import com.helger.base.location.SimpleLocation;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.diagnostics.error.IError;
import com.helger.diagnostics.error.SingleError;
import com.helger.diagnostics.error.SingleErrorBuilder;
import com.helger.diagnostics.error.level.EErrorLevel;
import com.helger.diagnostics.error.level.IErrorLevel;
import com.helger.text.IMultilingualText;
import com.helger.xml.transform.EXMLTransformTexts;
import com.helger.xml.transform.ITransformErrorListener;
import javax.xml.transform.SourceLocator;
import javax.xml.transform.TransformerException;
import org.jspecify.annotations.NonNull;

public abstract class AbstractTransformErrorListener
implements ITransformErrorListener {
    protected AbstractTransformErrorListener() {
    }

    private static @NonNull IError _buildError(@NonNull TransformerException transformerException, @NonNull IErrorLevel iErrorLevel, @NonNull IMultilingualText iMultilingualText) {
        SimpleLocation simpleLocation = SimpleLocation.create((SourceLocator)transformerException.getLocator());
        return ((SingleErrorBuilder)((SingleErrorBuilder)((SingleErrorBuilder)((SingleErrorBuilder)SingleError.builder().errorLevel(iErrorLevel)).errorLocation((ILocation)simpleLocation)).errorText(iMultilingualText)).linkedException((Throwable)transformerException)).build();
    }

    protected abstract void internalLog(@NonNull IError var1);

    @Override
    public final void warning(@NonNull TransformerException transformerException) throws TransformerException {
        this.internalLog(AbstractTransformErrorListener._buildError(transformerException, (IErrorLevel)EErrorLevel.WARN, EXMLTransformTexts.TRANSFORMATION_WARNING.getAsMLT()));
    }

    @Override
    public final void error(@NonNull TransformerException transformerException) throws TransformerException {
        this.internalLog(AbstractTransformErrorListener._buildError(transformerException, (IErrorLevel)EErrorLevel.ERROR, EXMLTransformTexts.TRANSFORMATION_ERROR.getAsMLT()));
    }

    @Override
    public final void fatalError(@NonNull TransformerException transformerException) throws TransformerException {
        this.internalLog(AbstractTransformErrorListener._buildError(transformerException, (IErrorLevel)EErrorLevel.FATAL_ERROR, EXMLTransformTexts.TRANSFORMATION_FATAL_ERROR.getAsMLT()));
    }

    public String toString() {
        return new ToStringGenerator((Object)this).getToString();
    }
}

