/*
 * Decompiled with CFR 0.152.
 */
package com.helger.xml.microdom.util;

import com.helger.annotation.WillClose;
import com.helger.annotation.concurrent.Immutable;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.io.EAppend;
import com.helger.base.io.iface.IHasInputStream;
import com.helger.base.io.iface.IHasOutputStream;
import com.helger.base.io.stream.StreamHelper;
import com.helger.base.state.ESuccess;
import com.helger.collection.commons.CommonsArrayList;
import com.helger.collection.commons.ICommonsList;
import com.helger.xml.microdom.IMicroDocument;
import com.helger.xml.microdom.IMicroElement;
import com.helger.xml.microdom.MicroDocument;
import com.helger.xml.microdom.serialize.MicroReader;
import com.helger.xml.microdom.serialize.MicroWriter;
import com.helger.xml.serialize.write.XMLWriterSettings;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public final class XMLListHandler {
    public static final String ELEMENT_LIST = "list";
    public static final String ELEMENT_ITEM = "item";
    public static final String ATTR_VALUE = "value";
    private static final Logger LOGGER = LoggerFactory.getLogger(XMLListHandler.class);
    private static final XMLListHandler INSTANCE = new XMLListHandler();

    private XMLListHandler() {
    }

    @ReturnsMutableCopy
    public static @Nullable ICommonsList<String> readList(@NonNull IHasInputStream iHasInputStream) {
        ValueEnforcer.notNull((Object)iHasInputStream, (String)"InputStreamProvider");
        return XMLListHandler.readList(iHasInputStream.getInputStream());
    }

    public static @NonNull ESuccess readList(@NonNull IHasInputStream iHasInputStream, @NonNull Collection<String> collection) {
        ValueEnforcer.notNull((Object)iHasInputStream, (String)"InputStreamProvider");
        return XMLListHandler.readList(iHasInputStream.getInputStream(), collection);
    }

    @ReturnsMutableCopy
    public static @Nullable ICommonsList<String> readList(@WillClose @NonNull InputStream inputStream) {
        CommonsArrayList commonsArrayList = new CommonsArrayList();
        if (XMLListHandler.readList(inputStream, (Collection<String>)commonsArrayList).isFailure()) {
            return null;
        }
        return commonsArrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static @NonNull ESuccess readList(@WillClose @NonNull InputStream inputStream, @NonNull Collection<String> collection) {
        ValueEnforcer.notNull((Object)inputStream, (String)"InputStream");
        ValueEnforcer.notNull(collection, (String)"TargetList");
        try {
            IMicroDocument iMicroDocument = MicroReader.readMicroXML(inputStream);
            if (iMicroDocument != null) {
                XMLListHandler.readList(iMicroDocument.getDocumentElement(), collection);
                ESuccess eSuccess = ESuccess.SUCCESS;
                return eSuccess;
            }
        }
        catch (Exception exception) {
            LOGGER.warn("Failed to read list resource '" + String.valueOf(inputStream) + "'", (Throwable)exception);
        }
        finally {
            StreamHelper.close((AutoCloseable)inputStream);
        }
        return ESuccess.FAILURE;
    }

    public static @NonNull ESuccess readList(@NonNull IMicroElement iMicroElement, @NonNull Collection<String> collection) {
        ValueEnforcer.notNull((Object)iMicroElement, (String)"ParentElement");
        ValueEnforcer.notNull(collection, (String)"TargetList");
        try {
            for (IMicroElement iMicroElement2 : iMicroElement.getAllChildElements(ELEMENT_ITEM)) {
                String string = iMicroElement2.getAttributeValue(ATTR_VALUE);
                if (string == null) {
                    LOGGER.warn("Ignoring list item because value is null");
                    continue;
                }
                if (collection.add(string)) continue;
                LOGGER.warn("Ignoring list item '" + string + "' because value is already contained");
            }
            return ESuccess.SUCCESS;
        }
        catch (Exception exception) {
            LOGGER.warn("Failed to read list document", (Throwable)exception);
            return ESuccess.FAILURE;
        }
    }

    public static @NonNull IMicroDocument createListDocument(@NonNull Collection<String> collection) {
        ValueEnforcer.notNull(collection, (String)"Collection");
        MicroDocument microDocument = new MicroDocument();
        IMicroElement iMicroElement = microDocument.addElement(ELEMENT_LIST);
        for (String string : collection) {
            IMicroElement iMicroElement2 = iMicroElement.addElement(ELEMENT_ITEM);
            iMicroElement2.setAttribute(ATTR_VALUE, string);
        }
        return microDocument;
    }

    public static @NonNull ESuccess writeList(@NonNull Collection<String> collection, @NonNull IHasOutputStream iHasOutputStream) {
        ValueEnforcer.notNull((Object)iHasOutputStream, (String)"OutputStreamProvider");
        return XMLListHandler.writeList(collection, iHasOutputStream.getOutputStream(EAppend.DEFAULT));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static @NonNull ESuccess writeList(@NonNull Collection<String> collection, @WillClose @NonNull OutputStream outputStream) {
        ValueEnforcer.notNull(collection, (String)"Collection");
        ValueEnforcer.notNull((Object)outputStream, (String)"OutputStream");
        try {
            IMicroDocument iMicroDocument = XMLListHandler.createListDocument(collection);
            ESuccess eSuccess = MicroWriter.writeToStream(iMicroDocument, outputStream, XMLWriterSettings.DEFAULT_XML_SETTINGS);
            return eSuccess;
        }
        finally {
            StreamHelper.close((AutoCloseable)outputStream);
        }
    }
}

