/*
 * Decompiled with CFR 0.152.
 */
package com.helger.xml.microdom.serialize;

import com.helger.annotation.Nonnegative;
import com.helger.annotation.WillClose;
import com.helger.annotation.concurrent.Immutable;
import com.helger.base.io.iface.IHasInputStream;
import com.helger.base.io.stream.StreamHelper;
import com.helger.io.resource.IReadableResource;
import com.helger.xml.EXMLParserFeature;
import com.helger.xml.microdom.IMicroDocument;
import com.helger.xml.microdom.serialize.MicroSAXHandler;
import com.helger.xml.sax.InputSourceFactory;
import com.helger.xml.serialize.read.ISAXReaderSettings;
import com.helger.xml.serialize.read.SAXReader;
import com.helger.xml.serialize.read.SAXReaderSettings;
import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.net.URI;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import org.jspecify.annotations.Nullable;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.ext.EntityResolver2;

@Immutable
public final class MicroReader {
    private static final MicroReader INSTANCE = new MicroReader();

    private MicroReader() {
    }

    public static @Nullable IMicroDocument readMicroXML(@WillClose @Nullable InputSource inputSource) {
        return MicroReader.readMicroXML(inputSource, (ISAXReaderSettings)null);
    }

    public static @Nullable IMicroDocument readMicroXML(@WillClose @Nullable InputSource inputSource, @Nullable ISAXReaderSettings iSAXReaderSettings) {
        if (inputSource == null) {
            return null;
        }
        EntityResolver entityResolver = iSAXReaderSettings == null ? null : iSAXReaderSettings.getEntityResolver();
        MicroSAXHandler microSAXHandler = new MicroSAXHandler(false, entityResolver, true);
        SAXReaderSettings sAXReaderSettings = SAXReaderSettings.createCloneOnDemand(iSAXReaderSettings);
        sAXReaderSettings.setEntityResolver(microSAXHandler).setDTDHandler(microSAXHandler).setContentHandler(microSAXHandler).setLexicalHandler(microSAXHandler);
        if (sAXReaderSettings.getErrorHandler() == null) {
            sAXReaderSettings.setErrorHandler(microSAXHandler);
        }
        if (entityResolver instanceof EntityResolver2) {
            sAXReaderSettings.setFeatureValue(EXMLParserFeature.USE_ENTITY_RESOLVER2, true);
        }
        if (SAXReader.readXMLSAX(inputSource, (ISAXReaderSettings)sAXReaderSettings).isFailure()) {
            return null;
        }
        return microSAXHandler.getDocument();
    }

    public static @Nullable IMicroDocument readMicroXML(@WillClose @Nullable InputStream inputStream) {
        return MicroReader.readMicroXML(inputStream, (ISAXReaderSettings)null);
    }

    public static @Nullable IMicroDocument readMicroXML(@WillClose @Nullable InputStream inputStream, @Nullable ISAXReaderSettings iSAXReaderSettings) {
        if (inputStream == null) {
            return null;
        }
        try {
            IMicroDocument iMicroDocument = MicroReader.readMicroXML(InputSourceFactory.create(inputStream), iSAXReaderSettings);
            return iMicroDocument;
        }
        finally {
            StreamHelper.close((AutoCloseable)inputStream);
        }
    }

    public static @Nullable IMicroDocument readMicroXML(@Nullable File file) {
        return MicroReader.readMicroXML(file, (ISAXReaderSettings)null);
    }

    public static @Nullable IMicroDocument readMicroXML(@Nullable File file, @Nullable ISAXReaderSettings iSAXReaderSettings) {
        if (file == null) {
            return null;
        }
        return MicroReader.readMicroXML(InputSourceFactory.create(file), iSAXReaderSettings);
    }

    public static @Nullable IMicroDocument readMicroXML(@Nullable Path path) {
        return MicroReader.readMicroXML(path, (ISAXReaderSettings)null);
    }

    public static @Nullable IMicroDocument readMicroXML(@Nullable Path path, @Nullable ISAXReaderSettings iSAXReaderSettings) {
        if (path == null) {
            return null;
        }
        return MicroReader.readMicroXML(InputSourceFactory.create(path), iSAXReaderSettings);
    }

    public static @Nullable IMicroDocument readMicroXML(@Nullable IReadableResource iReadableResource) {
        return MicroReader.readMicroXML(iReadableResource, (ISAXReaderSettings)null);
    }

    public static @Nullable IMicroDocument readMicroXML(@Nullable IReadableResource iReadableResource, @Nullable ISAXReaderSettings iSAXReaderSettings) {
        if (iReadableResource == null) {
            return null;
        }
        return MicroReader.readMicroXML(InputSourceFactory.create(iReadableResource), iSAXReaderSettings);
    }

    public static @Nullable IMicroDocument readMicroXML(@Nullable IHasInputStream iHasInputStream) {
        return MicroReader.readMicroXML(iHasInputStream, (ISAXReaderSettings)null);
    }

    public static @Nullable IMicroDocument readMicroXML(@Nullable IHasInputStream iHasInputStream, @Nullable ISAXReaderSettings iSAXReaderSettings) {
        if (iHasInputStream == null) {
            return null;
        }
        return MicroReader.readMicroXML(InputSourceFactory.create(iHasInputStream), iSAXReaderSettings);
    }

    public static @Nullable IMicroDocument readMicroXML(@WillClose @Nullable Reader reader) {
        return MicroReader.readMicroXML(reader, (ISAXReaderSettings)null);
    }

    public static @Nullable IMicroDocument readMicroXML(@WillClose @Nullable Reader reader, @Nullable ISAXReaderSettings iSAXReaderSettings) {
        if (reader == null) {
            return null;
        }
        try {
            IMicroDocument iMicroDocument = MicroReader.readMicroXML(InputSourceFactory.create(reader), iSAXReaderSettings);
            return iMicroDocument;
        }
        finally {
            StreamHelper.close((AutoCloseable)reader);
        }
    }

    public static @Nullable IMicroDocument readMicroXML(@Nullable String string) {
        return MicroReader.readMicroXML(string, (ISAXReaderSettings)null);
    }

    public static @Nullable IMicroDocument readMicroXML(@Nullable String string, @Nullable ISAXReaderSettings iSAXReaderSettings) {
        if (string == null) {
            return null;
        }
        return MicroReader.readMicroXML(InputSourceFactory.create(string), iSAXReaderSettings);
    }

    public static @Nullable IMicroDocument readMicroXML(@Nullable CharSequence charSequence) {
        return MicroReader.readMicroXML(charSequence, (ISAXReaderSettings)null);
    }

    public static @Nullable IMicroDocument readMicroXML(@Nullable CharSequence charSequence, @Nullable ISAXReaderSettings iSAXReaderSettings) {
        if (charSequence == null) {
            return null;
        }
        return MicroReader.readMicroXML(InputSourceFactory.create(charSequence), iSAXReaderSettings);
    }

    public static @Nullable IMicroDocument readMicroXML(byte @Nullable [] byArray) {
        return MicroReader.readMicroXML(byArray, (ISAXReaderSettings)null);
    }

    public static @Nullable IMicroDocument readMicroXML(byte @Nullable [] byArray, @Nullable ISAXReaderSettings iSAXReaderSettings) {
        if (byArray == null) {
            return null;
        }
        return MicroReader.readMicroXML(InputSourceFactory.create(byArray), iSAXReaderSettings);
    }

    public static @Nullable IMicroDocument readMicroXML(byte @Nullable [] byArray, @Nonnegative int n, @Nonnegative int n2) {
        return MicroReader.readMicroXML(byArray, n, n2, (ISAXReaderSettings)null);
    }

    public static @Nullable IMicroDocument readMicroXML(byte @Nullable [] byArray, @Nonnegative int n, @Nonnegative int n2, @Nullable ISAXReaderSettings iSAXReaderSettings) {
        if (byArray == null) {
            return null;
        }
        return MicroReader.readMicroXML(InputSourceFactory.create(byArray, n, n2), iSAXReaderSettings);
    }

    public static @Nullable IMicroDocument readMicroXML(char @Nullable [] cArray) {
        return MicroReader.readMicroXML(cArray, (ISAXReaderSettings)null);
    }

    public static @Nullable IMicroDocument readMicroXML(char @Nullable [] cArray, @Nullable ISAXReaderSettings iSAXReaderSettings) {
        if (cArray == null) {
            return null;
        }
        return MicroReader.readMicroXML(InputSourceFactory.create(cArray), iSAXReaderSettings);
    }

    public static @Nullable IMicroDocument readMicroXML(char @Nullable [] cArray, @Nonnegative int n, @Nonnegative int n2) {
        return MicroReader.readMicroXML(cArray, n, n2, (ISAXReaderSettings)null);
    }

    public static @Nullable IMicroDocument readMicroXML(char @Nullable [] cArray, @Nonnegative int n, @Nonnegative int n2, @Nullable ISAXReaderSettings iSAXReaderSettings) {
        if (cArray == null) {
            return null;
        }
        return MicroReader.readMicroXML(InputSourceFactory.create(cArray, n, n2), iSAXReaderSettings);
    }

    public static @Nullable IMicroDocument readMicroXML(@Nullable ByteBuffer byteBuffer) {
        return MicroReader.readMicroXML(byteBuffer, (ISAXReaderSettings)null);
    }

    public static @Nullable IMicroDocument readMicroXML(@Nullable ByteBuffer byteBuffer, @Nullable ISAXReaderSettings iSAXReaderSettings) {
        if (byteBuffer == null) {
            return null;
        }
        return MicroReader.readMicroXML(InputSourceFactory.create(byteBuffer), iSAXReaderSettings);
    }

    public static @Nullable IMicroDocument readMicroXML(@Nullable URI uRI) {
        return MicroReader.readMicroXML(uRI, (ISAXReaderSettings)null);
    }

    public static @Nullable IMicroDocument readMicroXML(@Nullable URI uRI, @Nullable ISAXReaderSettings iSAXReaderSettings) {
        if (uRI == null) {
            return null;
        }
        return MicroReader.readMicroXML(InputSourceFactory.create(uRI), iSAXReaderSettings);
    }

    public static @Nullable IMicroDocument readMicroXML(@Nullable URL uRL) {
        return MicroReader.readMicroXML(uRL, (ISAXReaderSettings)null);
    }

    public static @Nullable IMicroDocument readMicroXML(@Nullable URL uRL, @Nullable ISAXReaderSettings iSAXReaderSettings) {
        if (uRL == null) {
            return null;
        }
        return MicroReader.readMicroXML(InputSourceFactory.create(uRL), iSAXReaderSettings);
    }
}

