/*
 * Decompiled with CFR 0.152.
 */
package com.helger.xml.microdom;

import com.helger.annotation.Nonempty;
import com.helger.annotation.concurrent.Immutable;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.xml.microdom.AbstractMicroNode;
import com.helger.xml.microdom.EMicroNodeType;
import com.helger.xml.microdom.IMicroEntityReference;
import com.helger.xml.microdom.IMicroNode;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@Immutable
public final class MicroEntityReference
extends AbstractMicroNode
implements IMicroEntityReference {
    private final String m_sName;

    public MicroEntityReference(@NonNull @Nonempty String string) {
        this.m_sName = (String)ValueEnforcer.notEmpty((CharSequence)string, (String)"EntityReferenceName");
    }

    @Override
    public @NonNull EMicroNodeType getType() {
        return EMicroNodeType.ENTITY_REFERENCE;
    }

    @Override
    public @NonNull @Nonempty String getNodeName() {
        return "&" + this.m_sName + ";";
    }

    @Override
    public @NonNull @Nonempty String getNodeValue() {
        return this.getName();
    }

    @Override
    public @NonNull @Nonempty String getName() {
        return this.m_sName;
    }

    @Override
    public @NonNull IMicroEntityReference getClone() {
        return new MicroEntityReference(this.m_sName);
    }

    @Override
    public boolean isEqualContent(@Nullable IMicroNode iMicroNode) {
        if (iMicroNode == this) {
            return true;
        }
        if (iMicroNode == null || !this.getClass().equals(iMicroNode.getClass())) {
            return false;
        }
        MicroEntityReference microEntityReference = (MicroEntityReference)iMicroNode;
        return this.m_sName.equals(microEntityReference.m_sName);
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived((String)super.toString()).append("name", (Object)this.m_sName).getToString();
    }
}

