/*
 * Decompiled with CFR 0.152.
 */
package com.helger.xml.microdom;

import com.helger.annotation.Nonempty;
import com.helger.annotation.Nonnegative;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.callback.CallbackList;
import com.helger.base.clone.ICloneable;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.state.EChange;
import com.helger.collection.commons.CommonsArrayList;
import com.helger.collection.commons.ICommonsList;
import com.helger.collection.commons.ICommonsMap;
import com.helger.collection.hierarchy.IHasChildrenRecursive;
import com.helger.collection.hierarchy.IHasChildrenSorted;
import com.helger.collection.hierarchy.IHasParent;
import com.helger.typeconvert.impl.TypeConverter;
import com.helger.xml.microdom.EMicroEvent;
import com.helger.xml.microdom.EMicroNodeType;
import com.helger.xml.microdom.IMicroCDATA;
import com.helger.xml.microdom.IMicroComment;
import com.helger.xml.microdom.IMicroContainer;
import com.helger.xml.microdom.IMicroElement;
import com.helger.xml.microdom.IMicroEntityReference;
import com.helger.xml.microdom.IMicroEventTarget;
import com.helger.xml.microdom.IMicroProcessingInstruction;
import com.helger.xml.microdom.IMicroText;
import com.helger.xml.microdom.MicroCDATA;
import com.helger.xml.microdom.MicroComment;
import com.helger.xml.microdom.MicroContainer;
import com.helger.xml.microdom.MicroElement;
import com.helger.xml.microdom.MicroEntityReference;
import com.helger.xml.microdom.MicroProcessingInstruction;
import com.helger.xml.microdom.MicroText;
import java.util.function.Predicate;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public interface IMicroNode
extends ICloneable<IMicroNode>,
IHasChildrenSorted<IMicroNode>,
IHasChildrenRecursive<IMicroNode>,
IHasParent<IMicroNode> {
    public @NonNull @Nonempty String getNodeName();

    default public String getNodeValue() {
        return "";
    }

    public @Nullable ICommonsList<IMicroNode> getAllChildren();

    default public boolean containsAnyChild(@NonNull Predicate<? super IMicroNode> predicate) {
        ValueEnforcer.notNull(predicate, (String)"Filter");
        if (this.hasNoChildren()) {
            return false;
        }
        return this.getAllChildren().containsAny(predicate);
    }

    public @Nullable IMicroNode getFirstChild();

    public @Nullable IMicroNode getLastChild();

    default public @Nullable ICommonsList<IMicroNode> getAllChildrenRecursive() {
        if (this.hasNoChildren()) {
            return null;
        }
        CommonsArrayList commonsArrayList = new CommonsArrayList();
        this.forAllChildrenRecursive(arg_0 -> ((ICommonsList)commonsArrayList).add(arg_0));
        return commonsArrayList;
    }

    public @Nullable IMicroNode getPreviousSibling();

    public @Nullable IMicroNode getNextSibling();

    public boolean hasParent();

    public @Nullable IMicroNode getParent();

    public @NonNull IMicroNode detachFromParent();

    public @Nullable IMicroElement findParentElement(@NonNull Predicate<? super IMicroElement> var1);

    default public @Nullable IMicroElement getParentElementWithName(@Nullable String string) {
        return this.findParentElement(iMicroElement -> iMicroElement.getTagName().equals(string));
    }

    default public @Nullable IMicroElement getParentElementWithName(@Nullable String string, @Nullable String string2) {
        return this.findParentElement(iMicroElement -> iMicroElement.hasNamespaceURI(string) && iMicroElement.getTagName().equals(string2));
    }

    @Deprecated
    default public <NODETYPE extends IMicroNode> @Nullable NODETYPE appendChild(@Nullable NODETYPE NODETYPE) {
        return this.addChild(NODETYPE);
    }

    public <NODETYPE extends IMicroNode> @Nullable NODETYPE addChild(@Nullable NODETYPE var1);

    @Deprecated
    default public void appendChildren(IMicroNode ... iMicroNodeArray) {
        this.addChildren(iMicroNodeArray);
    }

    default public void addChildren(IMicroNode ... iMicroNodeArray) {
        if (iMicroNodeArray != null) {
            for (IMicroNode iMicroNode : iMicroNodeArray) {
                this.addChild(iMicroNode);
            }
        }
    }

    @Deprecated
    default public void appendChildren(@Nullable Iterable<? extends IMicroNode> iterable) {
        this.addChildren(iterable);
    }

    default public void addChildren(@Nullable Iterable<? extends IMicroNode> iterable) {
        if (iterable != null) {
            for (IMicroNode iMicroNode : iterable) {
                this.addChild(iMicroNode);
            }
        }
    }

    public <NODETYPE extends IMicroNode> @Nullable NODETYPE insertBefore(@Nullable NODETYPE var1, @NonNull IMicroNode var2);

    public <NODETYPE extends IMicroNode> @Nullable NODETYPE insertAfter(@Nullable NODETYPE var1, @NonNull IMicroNode var2);

    public <NODETYPE extends IMicroNode> @Nullable NODETYPE insertAtIndex(@Nonnegative int var1, @Nullable NODETYPE var2);

    @Deprecated
    default public @NonNull IMicroText appendText(boolean bl) {
        return this.addText(bl);
    }

    default public @NonNull IMicroText addText(boolean bl) {
        return this.addText(Boolean.toString(bl));
    }

    @Deprecated
    default public @NonNull IMicroText appendText(int n) {
        return this.addText(n);
    }

    default public @NonNull IMicroText addText(int n) {
        return this.addText(Integer.toString(n));
    }

    @Deprecated
    default public @NonNull IMicroText appendText(long l) {
        return this.addText(l);
    }

    default public @NonNull IMicroText addText(long l) {
        return this.addText(Long.toString(l));
    }

    @Deprecated
    default public @NonNull IMicroText appendText(@Nullable CharSequence charSequence) {
        return this.addText(charSequence);
    }

    default public @NonNull IMicroText addText(@Nullable CharSequence charSequence) {
        return this.addChild(new MicroText(charSequence, false));
    }

    @Deprecated
    default public @NonNull IMicroText appendText(char @NonNull [] cArray) {
        return this.addText(cArray);
    }

    default public @NonNull IMicroText addText(char @NonNull [] cArray) {
        return this.addText(cArray, 0, cArray.length);
    }

    @Deprecated
    default public @NonNull IMicroText appendText(char @NonNull [] cArray, @Nonnegative int n, @Nonnegative int n2) {
        return this.addText(cArray, n, n2);
    }

    default public @NonNull IMicroText addText(char @NonNull [] cArray, @Nonnegative int n, @Nonnegative int n2) {
        return this.addChild(new MicroText(cArray, n, n2, false));
    }

    @Deprecated
    default public @NonNull IMicroText appendTextWithConversion(@Nullable Object object) {
        return this.addTextWithConversion(object);
    }

    default public @NonNull IMicroText addTextWithConversion(@Nullable Object object) {
        String string = (String)TypeConverter.convert((Object)object, String.class);
        return this.addText(string);
    }

    @Deprecated
    default public @NonNull IMicroText appendIgnorableWhitespaceText(@Nullable CharSequence charSequence) {
        return this.addIgnorableWhitespaceText(charSequence);
    }

    default public @NonNull IMicroText addIgnorableWhitespaceText(@Nullable CharSequence charSequence) {
        return this.addChild(new MicroText(charSequence, true));
    }

    @Deprecated
    default public @NonNull IMicroText appendIgnorableWhitespaceText(char @NonNull [] cArray) {
        return this.addIgnorableWhitespaceText(cArray);
    }

    default public @NonNull IMicroText addIgnorableWhitespaceText(char @NonNull [] cArray) {
        return this.addIgnorableWhitespaceText(cArray, 0, cArray.length);
    }

    @Deprecated
    default public @NonNull IMicroText appendIgnorableWhitespaceText(char @NonNull [] cArray, @Nonnegative int n, @Nonnegative int n2) {
        return this.addIgnorableWhitespaceText(cArray, n, n2);
    }

    default public @NonNull IMicroText addIgnorableWhitespaceText(char @NonNull [] cArray, @Nonnegative int n, @Nonnegative int n2) {
        return this.addChild(new MicroText(cArray, n, n2, true));
    }

    @Deprecated
    default public @NonNull IMicroCDATA appendCDATA(@Nullable CharSequence charSequence) {
        return this.addCDATA(charSequence);
    }

    default public @NonNull IMicroCDATA addCDATA(@Nullable CharSequence charSequence) {
        return this.addChild(new MicroCDATA(charSequence));
    }

    @Deprecated
    default public @NonNull IMicroCDATA appendCDATA(char @NonNull [] cArray) {
        return this.addCDATA(cArray);
    }

    default public @NonNull IMicroCDATA addCDATA(char @NonNull [] cArray) {
        return this.addCDATA(cArray, 0, cArray.length);
    }

    @Deprecated
    default public @NonNull IMicroCDATA appendCDATA(char @NonNull [] cArray, @Nonnegative int n, @Nonnegative int n2) {
        return this.addCDATA(cArray, n, n2);
    }

    default public @NonNull IMicroCDATA addCDATA(char @NonNull [] cArray, @Nonnegative int n, @Nonnegative int n2) {
        return this.addChild(new MicroCDATA(cArray, n, n2));
    }

    @Deprecated
    default public @NonNull IMicroCDATA appendCDATAWithConversion(@Nullable Object object) {
        return this.addCDATAWithConversion(object);
    }

    default public @NonNull IMicroCDATA addCDATAWithConversion(@Nullable Object object) {
        String string = (String)TypeConverter.convert((Object)object, String.class);
        return this.addCDATA(string);
    }

    @Deprecated
    default public @NonNull IMicroComment appendComment(@Nullable CharSequence charSequence) {
        return this.addComment(charSequence);
    }

    default public @NonNull IMicroComment addComment(@Nullable CharSequence charSequence) {
        return this.addChild(new MicroComment(charSequence));
    }

    @Deprecated
    default public @NonNull IMicroComment appendComment(char @NonNull [] cArray) {
        return this.addComment(cArray);
    }

    default public @NonNull IMicroComment addComment(char @NonNull [] cArray) {
        return this.addComment(cArray, 0, cArray.length);
    }

    @Deprecated
    default public @NonNull IMicroComment appendComment(char @NonNull [] cArray, @Nonnegative int n, @Nonnegative int n2) {
        return this.addComment(cArray, n, n2);
    }

    default public @NonNull IMicroComment addComment(char @NonNull [] cArray, @Nonnegative int n, @Nonnegative int n2) {
        return this.addChild(new MicroComment(cArray, n, n2));
    }

    @Deprecated
    default public @NonNull IMicroComment appendCommentWithConversion(@Nullable Object object) {
        return this.addCommentWithConversion(object);
    }

    default public @NonNull IMicroComment addCommentWithConversion(@Nullable Object object) {
        String string = (String)TypeConverter.convert((Object)object, String.class);
        return this.addComment(string);
    }

    @Deprecated
    default public @NonNull IMicroEntityReference appendEntityReference(@NonNull String string) {
        return this.addEntityReference(string);
    }

    default public @NonNull IMicroEntityReference addEntityReference(@NonNull String string) {
        return this.addChild(new MicroEntityReference(string));
    }

    @Deprecated
    default public @NonNull IMicroElement appendElement(@NonNull @Nonempty String string) {
        return this.addElement(string);
    }

    default public @NonNull IMicroElement addElement(@NonNull @Nonempty String string) {
        return this.addElementNS(null, string);
    }

    @Deprecated
    default public @NonNull IMicroElement appendElement(@Nullable String string, @NonNull @Nonempty String string2) {
        return this.addElementNS(string, string2);
    }

    default public @NonNull IMicroElement addElementNS(@Nullable String string, @NonNull @Nonempty String string2) {
        return this.addChild(new MicroElement(string, string2));
    }

    @Deprecated
    default public @NonNull IMicroProcessingInstruction appendProcessingInstruction(@NonNull @Nonempty String string, @Nullable String string2) {
        return this.addProcessingInstruction(string, string2);
    }

    default public @NonNull IMicroProcessingInstruction addProcessingInstruction(@NonNull @Nonempty String string, @Nullable String string2) {
        return this.addChild(new MicroProcessingInstruction(string, string2));
    }

    @Deprecated
    default public @NonNull IMicroContainer appendContainer() {
        return this.addContainer();
    }

    default public @NonNull IMicroContainer addContainer() {
        return this.addChild(new MicroContainer());
    }

    public @NonNull EChange removeChild(@NonNull IMicroNode var1);

    public @NonNull EChange removeChildAtIndex(@Nonnegative int var1);

    public @NonNull EChange removeAllChildren();

    default public @NonNull EChange replaceChild(@NonNull IMicroNode iMicroNode, @NonNull IMicroNode iMicroNode2) {
        ValueEnforcer.notNull((Object)iMicroNode, (String)"OldChild");
        ValueEnforcer.notNull((Object)iMicroNode2, (String)"NewChild");
        if (iMicroNode.equals(iMicroNode2)) {
            return EChange.UNCHANGED;
        }
        this.insertBefore(iMicroNode2, iMicroNode);
        this.removeChild(iMicroNode);
        return EChange.CHANGED;
    }

    public @NonNull EMicroNodeType getType();

    public boolean isDocument();

    public boolean isDocumentType();

    public boolean isText();

    public boolean isCDATA();

    public boolean isComment();

    public boolean isEntityReference();

    public boolean isElement();

    public boolean isProcessingInstruction();

    public boolean isContainer();

    public @NonNull EChange registerEventTarget(@NonNull EMicroEvent var1, @NonNull IMicroEventTarget var2);

    public @NonNull EChange unregisterEventTarget(@NonNull EMicroEvent var1, @NonNull IMicroEventTarget var2);

    @ReturnsMutableCopy
    public @NonNull ICommonsMap<EMicroEvent, CallbackList<IMicroEventTarget>> getAllEventTargets();

    @ReturnsMutableCopy
    public @NonNull CallbackList<IMicroEventTarget> getAllEventTargets(@Nullable EMicroEvent var1);

    public boolean isEqualContent(@Nullable IMicroNode var1);
}

