/*
 * Decompiled with CFR 0.152.
 */
package com.helger.xml.microdom;

import com.helger.annotation.Nonnegative;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.equals.EqualsHelper;
import com.helger.base.numeric.mutable.MutableInt;
import com.helger.base.state.EChange;
import com.helger.base.state.EContinue;
import com.helger.base.string.StringHelper;
import com.helger.collection.commons.CommonsArrayList;
import com.helger.collection.commons.ICommonsList;
import com.helger.xml.microdom.IMicroAttributeContainer;
import com.helger.xml.microdom.IMicroNodeWithChildren;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public interface IMicroElement
extends IMicroNodeWithChildren,
IMicroAttributeContainer<IMicroElement> {
    public @Nullable String getNamespaceURI();

    public @NonNull EChange setNamespaceURI(@Nullable String var1);

    default public boolean hasNamespaceURI() {
        return this.getNamespaceURI() != null;
    }

    default public boolean hasNoNamespaceURI() {
        return this.getNamespaceURI() == null;
    }

    default public boolean hasNamespaceURI(@Nullable String string) {
        return EqualsHelper.equals((Object)this.getNamespaceURI(), (Object)string);
    }

    public @Nullable String getLocalName();

    default public boolean hasLocalName(@Nullable String string) {
        return EqualsHelper.equals((Object)this.getLocalName(), (Object)string);
    }

    public @NonNull String getTagName();

    default public boolean hasTagName(@Nullable String string) {
        return this.getTagName().equals(string);
    }

    default public boolean hasTagNameIgnoreCase(@Nullable String string) {
        return this.getTagName().equalsIgnoreCase(string);
    }

    @Nonnegative
    default public int getChildElementCount() {
        return this.getChildElementCount(null);
    }

    @Nonnegative
    default public int getChildElementCount(@Nullable Predicate<? super IMicroElement> predicate) {
        MutableInt mutableInt = new MutableInt(0);
        this.forAllChildElements(predicate, iMicroElement -> mutableInt.inc());
        return mutableInt.intValue();
    }

    @ReturnsMutableCopy
    default public @NonNull ICommonsList<IMicroElement> getAllChildElements() {
        return this.getAllChildElements((Predicate<? super IMicroElement>)null);
    }

    @ReturnsMutableCopy
    default public @NonNull ICommonsList<IMicroElement> getAllChildElements(@Nullable String string) {
        return this.getAllChildElements(IMicroElement.filterName(string));
    }

    @ReturnsMutableCopy
    default public @NonNull ICommonsList<IMicroElement> getAllChildElements(@Nullable String string, @Nullable String string2) {
        return this.getAllChildElements(IMicroElement.filterNamespaceURIAndName(string, string2));
    }

    @ReturnsMutableCopy
    default public @NonNull ICommonsList<IMicroElement> getAllChildElements(@Nullable Predicate<? super IMicroElement> predicate) {
        CommonsArrayList commonsArrayList = new CommonsArrayList();
        this.forAllChildElements(predicate, arg_0 -> ((ICommonsList)commonsArrayList).add(arg_0));
        return commonsArrayList;
    }

    @ReturnsMutableCopy
    public @NonNull ICommonsList<IMicroElement> getAllChildElementsRecursive();

    default public boolean hasChildElements() {
        return this.containsAnyChildElement(null);
    }

    default public boolean hasChildElements(@Nullable String string) {
        return this.containsAnyChildElement(IMicroElement.filterName(string));
    }

    default public boolean hasChildElements(@Nullable String string, @Nullable String string2) {
        return this.containsAnyChildElement(IMicroElement.filterNamespaceURIAndName(string, string2));
    }

    public boolean containsAnyChildElement(@Nullable Predicate<? super IMicroElement> var1);

    default public @Nullable IMicroElement getFirstChildElement() {
        return this.getFirstChildElement((Predicate<? super IMicroElement>)null);
    }

    default public @Nullable IMicroElement getFirstChildElement(@Nullable String string) {
        return this.getFirstChildElement(IMicroElement.filterName(string));
    }

    default public @Nullable IMicroElement getFirstChildElement(@Nullable String string, @Nullable String string2) {
        return this.getFirstChildElement(IMicroElement.filterNamespaceURIAndName(string, string2));
    }

    public @Nullable IMicroElement getFirstChildElement(@Nullable Predicate<? super IMicroElement> var1);

    default public void forAllChildElements(@NonNull Consumer<? super IMicroElement> consumer) {
        this.forAllChildElements(null, consumer);
    }

    public void forAllChildElements(@Nullable Predicate<? super IMicroElement> var1, @NonNull Consumer<? super IMicroElement> var2);

    default public @NonNull EContinue forAllChildElementsBreakable(@NonNull Function<? super IMicroElement, EContinue> function) {
        return this.forAllChildElementsBreakable(null, function);
    }

    public @NonNull EContinue forAllChildElementsBreakable(@Nullable Predicate<? super IMicroElement> var1, @NonNull Function<? super IMicroElement, EContinue> var2);

    @Override
    public @NonNull IMicroElement getClone();

    public static @NonNull Predicate<? super IMicroElement> filterNamespaceURI(@Nullable String string) {
        return iMicroElement -> iMicroElement.hasNamespaceURI(string);
    }

    public static @NonNull Predicate<? super IMicroElement> filterName(@Nullable String string) {
        return iMicroElement -> iMicroElement.hasTagName(string);
    }

    public static @NonNull Predicate<? super IMicroElement> filterNamespaceURIAndName(@Nullable String string, @Nullable String string2) {
        if (StringHelper.isEmpty((String)string)) {
            return IMicroElement.filterName(string2);
        }
        return iMicroElement -> iMicroElement.hasNamespaceURI(string) && iMicroElement.hasLocalName(string2);
    }
}

