/*
 * Decompiled with CFR 0.152.
 */
package com.helger.xml.transform;

import com.helger.annotation.Nonnegative;
import com.helger.annotation.concurrent.Immutable;
import com.helger.base.io.iface.IHasInputStream;
import com.helger.base.io.nonblocking.NonBlockingByteArrayInputStream;
import com.helger.base.io.stream.ByteBufferInputStream;
import com.helger.base.url.URLHelper;
import com.helger.io.resource.IReadableResource;
import com.helger.io.resource.URLResource;
import com.helger.xml.transform.CachingTransformStreamSource;
import com.helger.xml.transform.StringStreamSource;
import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.net.URI;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;
import org.w3c.dom.Node;

@Immutable
public final class TransformSourceFactory {
    private static final TransformSourceFactory INSTANCE = new TransformSourceFactory();

    private TransformSourceFactory() {
    }

    public static @NonNull StreamSource create(@NonNull File file) {
        return new StreamSource(file);
    }

    public static @NonNull StreamSource create(@NonNull Path path) {
        return new StreamSource(path.toFile());
    }

    public static @NonNull StreamSource create(@NonNull URI uRI) {
        return TransformSourceFactory.create(URLHelper.getAsURL((URI)uRI));
    }

    public static @NonNull StreamSource create(@NonNull URL uRL) {
        return TransformSourceFactory.create((IReadableResource)new URLResource(uRL));
    }

    public static @NonNull StreamSource create(@NonNull IHasInputStream iHasInputStream) {
        if (iHasInputStream instanceof IReadableResource) {
            IReadableResource iReadableResource = (IReadableResource)iHasInputStream;
            return TransformSourceFactory.create(iReadableResource);
        }
        return TransformSourceFactory.create(iHasInputStream.getInputStream());
    }

    public static @NonNull StreamSource create(@NonNull IReadableResource iReadableResource) {
        return new CachingTransformStreamSource(iReadableResource);
    }

    public static @NonNull StringStreamSource create(@NonNull CharSequence charSequence) {
        return new StringStreamSource(charSequence);
    }

    public static @NonNull StringStreamSource create(@NonNull String string) {
        return new StringStreamSource(string);
    }

    public static @NonNull StringStreamSource create(char @NonNull [] cArray) {
        return new StringStreamSource(cArray);
    }

    public static @NonNull StringStreamSource create(char @NonNull [] cArray, @Nonnegative int n, @Nonnegative int n2) {
        return new StringStreamSource(cArray, n, n2);
    }

    public static @NonNull StreamSource create(byte @NonNull [] byArray) {
        return TransformSourceFactory.create((InputStream)new NonBlockingByteArrayInputStream(byArray));
    }

    public static @NonNull StreamSource create(byte @NonNull [] byArray, @Nonnegative int n, @Nonnegative int n2) {
        return TransformSourceFactory.create((InputStream)new NonBlockingByteArrayInputStream(byArray, n, n2));
    }

    public static @NonNull StreamSource create(@NonNull ByteBuffer byteBuffer) {
        return TransformSourceFactory.create((InputStream)new ByteBufferInputStream(byteBuffer));
    }

    public static @NonNull StreamSource create(@Nullable InputStream inputStream) {
        return new StreamSource(inputStream);
    }

    public static @NonNull StreamSource create(@Nullable Reader reader) {
        return new StreamSource(reader);
    }

    public static @NonNull DOMSource create(@Nullable Node node) {
        return new DOMSource(node);
    }
}

