/*
 * Decompiled with CFR 0.152.
 */
package com.helger.xml.microdom.util;

import com.helger.annotation.Nonempty;
import com.helger.annotation.Nonnegative;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.string.StringHelper;
import com.helger.collection.commons.CommonsArrayList;
import com.helger.collection.commons.ICommonsList;
import com.helger.collection.hierarchy.IChildrenProvider;
import com.helger.xml.microdom.IMicroElement;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public final class ChildrenProviderElementWithName
implements IChildrenProvider<IMicroElement> {
    private final String m_sNamespaceURI;
    private final String m_sTagName;

    public ChildrenProviderElementWithName(@NonNull @Nonempty String string) {
        this(null, string);
    }

    public ChildrenProviderElementWithName(@Nullable String string, @NonNull @Nonempty String string2) {
        this.m_sNamespaceURI = string;
        this.m_sTagName = (String)ValueEnforcer.notEmpty((CharSequence)string2, (String)"TagName");
    }

    public boolean hasChildren(@Nullable IMicroElement iMicroElement) {
        if (iMicroElement == null || !iMicroElement.isElement()) {
            return false;
        }
        if (StringHelper.isNotEmpty((String)this.m_sNamespaceURI)) {
            return iMicroElement.hasChildElements(this.m_sNamespaceURI, this.m_sTagName);
        }
        return iMicroElement.hasChildElements(this.m_sTagName);
    }

    @Nonnegative
    public int getChildCount(@Nullable IMicroElement iMicroElement) {
        if (iMicroElement == null) {
            return 0;
        }
        return this.getAllChildren(iMicroElement).size();
    }

    @ReturnsMutableCopy
    public @NonNull ICommonsList<? extends IMicroElement> getAllChildren(@Nullable IMicroElement iMicroElement) {
        if (iMicroElement == null) {
            return new CommonsArrayList();
        }
        if (StringHelper.isNotEmpty((String)this.m_sNamespaceURI)) {
            return iMicroElement.getAllChildElements(this.m_sNamespaceURI, this.m_sTagName);
        }
        return iMicroElement.getAllChildElements(this.m_sTagName);
    }
}

