/*
 * Decompiled with CFR 0.152.
 */
package com.helger.xml.microdom;

import com.helger.annotation.Nonempty;
import com.helger.annotation.Nonnegative;
import com.helger.annotation.style.ReturnsImmutableObject;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.debug.GlobalDebug;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.equals.EqualsHelper;
import com.helger.base.functional.ITriConsumer;
import com.helger.base.state.EChange;
import com.helger.base.state.EContinue;
import com.helger.base.string.StringHelper;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.base.wrapper.Wrapper;
import com.helger.collection.commons.CommonsArrayList;
import com.helger.collection.commons.CommonsLinkedHashMap;
import com.helger.collection.commons.ICommonsList;
import com.helger.collection.commons.ICommonsOrderedMap;
import com.helger.collection.commons.ICommonsOrderedSet;
import com.helger.typeconvert.impl.TypeConverter;
import com.helger.xml.CXMLRegEx;
import com.helger.xml.microdom.AbstractMicroNodeWithChildren;
import com.helger.xml.microdom.EMicroNodeType;
import com.helger.xml.microdom.IMicroAttribute;
import com.helger.xml.microdom.IMicroElement;
import com.helger.xml.microdom.IMicroNode;
import com.helger.xml.microdom.IMicroQName;
import com.helger.xml.microdom.MicroAttribute;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MicroElement
extends AbstractMicroNodeWithChildren
implements IMicroElement {
    private static final Logger LOGGER = LoggerFactory.getLogger(MicroElement.class);
    private String m_sNamespaceURI;
    private final String m_sTagName;
    private ICommonsOrderedMap<IMicroQName, MicroAttribute> m_aAttrs;

    public MicroElement(@NonNull @Nonempty String string) {
        this(null, string);
    }

    public MicroElement(@Nullable String string, @NonNull @Nonempty String string2) {
        int n;
        ValueEnforcer.notEmpty((CharSequence)string2, (String)"TagName");
        this.m_sNamespaceURI = string;
        int n2 = n = string != null ? string2.indexOf(58) : -1;
        if (n == -1) {
            this.m_sTagName = string2;
        } else {
            LOGGER.warn("Removing micro element namespace prefix '" + string2.substring(0, n) + "' from tag name '" + string2 + "'");
            this.m_sTagName = string2.substring(n + 1);
        }
        if (GlobalDebug.isDebugMode() && !CXMLRegEx.PATTERN_NAME_QUICK.matcher(this.m_sTagName).matches() && !CXMLRegEx.PATTERN_NAME.matcher(this.m_sTagName).matches()) {
            throw new IllegalArgumentException("The micro element tag name '" + this.m_sTagName + "' is not a valid element name!");
        }
    }

    @Override
    public @NonNull EMicroNodeType getType() {
        return EMicroNodeType.ELEMENT;
    }

    @Override
    public @NonNull @Nonempty String getNodeName() {
        return this.getTagName();
    }

    @Override
    public boolean hasAttributes() {
        return this.m_aAttrs != null && this.m_aAttrs.isNotEmpty();
    }

    @Override
    public boolean hasNoAttributes() {
        return this.m_aAttrs == null || this.m_aAttrs.isEmpty();
    }

    @Override
    @Nonnegative
    public int getAttributeCount() {
        return this.m_aAttrs == null ? 0 : this.m_aAttrs.size();
    }

    @Override
    @ReturnsImmutableObject
    public @Nullable Iterable<MicroAttribute> getAttributeObjs() {
        if (this.hasNoAttributes()) {
            return null;
        }
        return this.m_aAttrs.values();
    }

    @Override
    @ReturnsMutableCopy
    public @Nullable ICommonsList<MicroAttribute> getAllAttributeObjs() {
        if (this.hasNoAttributes()) {
            return null;
        }
        return this.m_aAttrs.copyOfValues();
    }

    @Override
    @ReturnsMutableCopy
    public @Nullable ICommonsOrderedMap<IMicroQName, String> getAllQAttributes() {
        if (this.hasNoAttributes()) {
            return null;
        }
        return new CommonsLinkedHashMap(this.m_aAttrs.values(), IMicroAttribute::getAttributeQName, IMicroAttribute::getAttributeValue);
    }

    @Override
    @ReturnsMutableCopy
    public @Nullable ICommonsOrderedSet<IMicroQName> getAllAttributeQNames() {
        if (this.hasNoAttributes()) {
            return null;
        }
        return this.m_aAttrs.copyOfKeySet();
    }

    @Override
    public void forAllAttributes(@NonNull Consumer<? super IMicroAttribute> consumer) {
        if (this.m_aAttrs != null) {
            this.m_aAttrs.forEachValue(consumer);
        }
    }

    @Override
    public void forAllAttributes(@NonNull BiConsumer<? super IMicroQName, ? super String> biConsumer) {
        if (this.m_aAttrs != null) {
            this.m_aAttrs.forEachValue(microAttribute -> biConsumer.accept(microAttribute.getAttributeQName(), microAttribute.getAttributeValue()));
        }
    }

    @Override
    public void forAllAttributes(@NonNull ITriConsumer<? super String, ? super String, ? super String> iTriConsumer) {
        if (this.m_aAttrs != null) {
            this.m_aAttrs.forEachValue(microAttribute -> iTriConsumer.accept((Object)microAttribute.getNamespaceURI(), (Object)microAttribute.getAttributeName(), (Object)microAttribute.getAttributeValue()));
        }
    }

    @Override
    public @Nullable MicroAttribute getAttributeObj(@Nullable IMicroQName iMicroQName) {
        return iMicroQName == null || this.m_aAttrs == null ? null : (MicroAttribute)this.m_aAttrs.get((Object)iMicroQName);
    }

    private static <DSTTYPE> @Nullable DSTTYPE _getConvertedToType(@Nullable String string, @NonNull Class<DSTTYPE> clazz) {
        if (StringHelper.isEmpty((String)string)) {
            return null;
        }
        return (DSTTYPE)TypeConverter.convert((Object)string, clazz);
    }

    @Override
    public <DSTTYPE> @Nullable DSTTYPE getAttributeValueWithConversion(@Nullable IMicroQName iMicroQName, @NonNull Class<DSTTYPE> clazz) {
        String string = this.getAttributeValue(iMicroQName);
        return MicroElement._getConvertedToType(string, clazz);
    }

    @Override
    public boolean hasAttribute(@Nullable IMicroQName iMicroQName) {
        return this.m_aAttrs != null && iMicroQName != null && this.m_aAttrs.containsKey((Object)iMicroQName);
    }

    @Override
    public @NonNull EChange removeAttribute(@Nullable IMicroQName iMicroQName) {
        if (this.m_aAttrs == null || iMicroQName == null) {
            return EChange.UNCHANGED;
        }
        return this.m_aAttrs.removeObject((Object)iMicroQName);
    }

    @Override
    public @NonNull MicroElement setAttribute(@NonNull IMicroQName iMicroQName, @Nullable String string) {
        ValueEnforcer.notNull((Object)iMicroQName, (String)"AttrName");
        if (string != null) {
            if (this.m_aAttrs == null) {
                this.m_aAttrs = new CommonsLinkedHashMap();
            }
            this.m_aAttrs.put((Object)iMicroQName, (Object)new MicroAttribute(iMicroQName, string));
        } else {
            this.removeAttribute(iMicroQName);
        }
        return this;
    }

    @Override
    public @NonNull EChange removeAllAttributes() {
        if (this.m_aAttrs == null) {
            return EChange.UNCHANGED;
        }
        return this.m_aAttrs.removeAll();
    }

    @Override
    public @Nullable String getNamespaceURI() {
        return this.m_sNamespaceURI;
    }

    @Override
    public @NonNull EChange setNamespaceURI(@Nullable String string) {
        String string2 = this.m_sNamespaceURI;
        if (EqualsHelper.equals((Object)string2, (Object)string)) {
            return EChange.UNCHANGED;
        }
        this.m_sNamespaceURI = string;
        return EChange.CHANGED;
    }

    @Override
    public @Nullable String getLocalName() {
        return this.m_sNamespaceURI == null ? null : this.m_sTagName;
    }

    @Override
    public @NonNull String getTagName() {
        return this.m_sTagName;
    }

    @Override
    @ReturnsMutableCopy
    public @NonNull ICommonsList<IMicroElement> getAllChildElementsRecursive() {
        CommonsArrayList commonsArrayList = new CommonsArrayList();
        MicroElement._forAllChildElements(this, null, arg_0 -> MicroElement.lambda$getAllChildElementsRecursive$2((ICommonsList)commonsArrayList, arg_0));
        return commonsArrayList;
    }

    private static boolean _containsChildElementRecursive(@NonNull IMicroNode iMicroNode2, @Nullable Predicate<? super IMicroElement> predicate) {
        return iMicroNode2.containsAnyChild(iMicroNode -> {
            if (iMicroNode.isElement()) {
                IMicroElement iMicroElement = (IMicroElement)iMicroNode;
                if (predicate == null || predicate.test(iMicroElement)) {
                    return true;
                }
            } else if (iMicroNode.isContainer() && MicroElement._containsChildElementRecursive(iMicroNode, predicate)) {
                return true;
            }
            return false;
        });
    }

    @Override
    public boolean containsAnyChildElement(@Nullable Predicate<? super IMicroElement> predicate) {
        return MicroElement._containsChildElementRecursive(this, predicate);
    }

    private static @NonNull EContinue _forAllChildElementsBreakable(@NonNull IMicroNode iMicroNode2, @Nullable Predicate<? super IMicroElement> predicate, @NonNull Function<? super IMicroElement, EContinue> function) {
        return iMicroNode2.forAllChildrenBreakable(iMicroNode -> {
            if (iMicroNode.isElement()) {
                IMicroElement iMicroElement = (IMicroElement)iMicroNode;
                if ((predicate == null || predicate.test(iMicroElement)) && ((EContinue)function.apply(iMicroElement)).isBreak()) {
                    return EContinue.BREAK;
                }
            } else if (iMicroNode.isContainer() && MicroElement._forAllChildElementsBreakable(iMicroNode, predicate, function).isBreak()) {
                return EContinue.BREAK;
            }
            return EContinue.CONTINUE;
        });
    }

    private static IMicroElement _findFirstChildElement(@NonNull IMicroNode iMicroNode, @Nullable Predicate<? super IMicroElement> predicate) {
        Wrapper wrapper = new Wrapper();
        MicroElement._forAllChildElementsBreakable(iMicroNode, predicate, iMicroElement -> {
            assert (wrapper.isNotSet());
            wrapper.set(iMicroElement);
            return EContinue.BREAK;
        });
        return (IMicroElement)wrapper.get();
    }

    @Override
    public @Nullable IMicroElement getFirstChildElement(@Nullable Predicate<? super IMicroElement> predicate) {
        return MicroElement._findFirstChildElement(this, predicate);
    }

    private static void _forAllChildElements(@NonNull IMicroNode iMicroNode2, @Nullable Predicate<? super IMicroElement> predicate, @NonNull Consumer<? super IMicroElement> consumer) {
        iMicroNode2.forAllChildren(iMicroNode -> {
            if (iMicroNode.isElement()) {
                IMicroElement iMicroElement = (IMicroElement)iMicroNode;
                if (predicate == null || predicate.test(iMicroElement)) {
                    consumer.accept(iMicroElement);
                }
            } else if (iMicroNode.isContainer()) {
                MicroElement._forAllChildElements(iMicroNode, predicate, consumer);
            }
        });
    }

    @Override
    public void forAllChildElements(@Nullable Predicate<? super IMicroElement> predicate, @NonNull Consumer<? super IMicroElement> consumer) {
        MicroElement._forAllChildElements(this, predicate, consumer);
    }

    @Override
    public @NonNull EContinue forAllChildElementsBreakable(@Nullable Predicate<? super IMicroElement> predicate, @NonNull Function<? super IMicroElement, EContinue> function) {
        return MicroElement._forAllChildElementsBreakable(this, predicate, function);
    }

    @Override
    public @NonNull IMicroElement getClone() {
        MicroElement microElement = new MicroElement(this.m_sNamespaceURI, this.m_sTagName);
        if (this.m_aAttrs != null) {
            microElement.m_aAttrs = new CommonsLinkedHashMap(this.m_aAttrs);
        }
        this.forAllChildren(iMicroNode -> microElement.addChild((IMicroNode)iMicroNode.getClone()));
        return microElement;
    }

    @Override
    public boolean isEqualContent(@Nullable IMicroNode iMicroNode) {
        if (iMicroNode == this) {
            return true;
        }
        if (!super.isEqualContent(iMicroNode)) {
            return false;
        }
        MicroElement microElement = (MicroElement)iMicroNode;
        String string = this.m_sNamespaceURI;
        ICommonsOrderedMap<IMicroQName, MicroAttribute> iCommonsOrderedMap = this.m_aAttrs;
        return EqualsHelper.equals((Object)string, (Object)microElement.m_sNamespaceURI) && this.m_sTagName.equals(microElement.m_sTagName) && EqualsHelper.equals(iCommonsOrderedMap, microElement.m_aAttrs);
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived((String)super.toString()).appendIfNotNull("namespace", (Object)this.m_sNamespaceURI).append("tagname", (Object)this.m_sTagName).appendIfNotNull("attrs", this.m_aAttrs).getToString();
    }

    private static /* synthetic */ void lambda$getAllChildElementsRecursive$2(ICommonsList iCommonsList, IMicroElement iMicroElement) {
        iCommonsList.add((Object)iMicroElement);
        iCommonsList.addAll(iMicroElement.getAllChildElementsRecursive());
    }
}

