/*
 * Decompiled with CFR 0.152.
 */
package com.helger.xml.microdom.convert;

import com.helger.annotation.Nonempty;
import com.helger.annotation.concurrent.ThreadSafe;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.reflection.GenericReflection;
import com.helger.typeconvert.TypeConverterException;
import com.helger.xml.microdom.IMicroElement;
import com.helger.xml.microdom.convert.IMicroTypeConverter;
import com.helger.xml.microdom.convert.MicroTypeConverterRegistry;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@ThreadSafe
public final class MicroTypeConverter {
    private static final MicroTypeConverter INSTANCE = new MicroTypeConverter();

    private MicroTypeConverter() {
    }

    public static <T> @Nullable IMicroElement convertToMicroElement(@Nullable T t, @Nonempty @NonNull String string) {
        return MicroTypeConverter.convertToMicroElement(t, null, string);
    }

    public static <T> @Nullable IMicroElement convertToMicroElement(@Nullable T t, @Nullable String string, @Nonempty @NonNull String string2) {
        ValueEnforcer.notEmpty((CharSequence)string2, (String)"TagName");
        if (t == null) {
            return null;
        }
        Class clazz = (Class)GenericReflection.uncheckedCast(t.getClass());
        IMicroTypeConverter<T> iMicroTypeConverter = MicroTypeConverterRegistry.getInstance().getConverterToMicroElement(clazz);
        if (iMicroTypeConverter == null) {
            throw new TypeConverterException(clazz, IMicroElement.class, TypeConverterException.EReason.NO_CONVERTER_FOUND);
        }
        IMicroElement iMicroElement = iMicroTypeConverter.convertToMicroElement(t, string, string2);
        if (iMicroElement == null) {
            throw new TypeConverterException(clazz, IMicroElement.class, TypeConverterException.EReason.CONVERSION_FAILED);
        }
        return iMicroElement;
    }

    public static <DSTTYPE> @Nullable DSTTYPE convertToNative(@Nullable IMicroElement iMicroElement, @NonNull Class<DSTTYPE> clazz) {
        return MicroTypeConverter.convertToNative(iMicroElement, clazz, null);
    }

    public static <DSTTYPE> @Nullable DSTTYPE convertToNative(@Nullable IMicroElement iMicroElement, @NonNull Class<DSTTYPE> clazz, @Nullable DSTTYPE DSTTYPE) {
        ValueEnforcer.notNull(clazz, (String)"DestClass");
        if (iMicroElement == null) {
            return DSTTYPE;
        }
        IMicroTypeConverter<DSTTYPE> iMicroTypeConverter = MicroTypeConverterRegistry.getInstance().getConverterToNative(clazz);
        if (iMicroTypeConverter == null) {
            throw new TypeConverterException(IMicroElement.class, clazz, TypeConverterException.EReason.NO_CONVERTER_FOUND);
        }
        DSTTYPE DSTTYPE2 = iMicroTypeConverter.convertToNative(iMicroElement);
        if (DSTTYPE2 == null) {
            throw new TypeConverterException(IMicroElement.class, clazz, TypeConverterException.EReason.CONVERSION_FAILED);
        }
        return DSTTYPE2;
    }
}

