/*
 * Decompiled with CFR 0.152.
 */
package com.helger.xml;

import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.collection.commons.ICommonsIterableIterator;
import java.util.NoSuchElementException;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class NodeListIterator
implements ICommonsIterableIterator<Node> {
    private final NodeList m_aNL;
    private int m_nIndex = 0;
    private final int m_nMax;

    public NodeListIterator(@Nullable NodeList nodeList) {
        this.m_aNL = nodeList;
        this.m_nMax = nodeList == null ? 0 : nodeList.getLength();
    }

    public boolean hasNext() {
        return this.m_nIndex < this.m_nMax;
    }

    public @Nullable Node next() {
        if (this.m_nIndex >= this.m_nMax) {
            throw new NoSuchElementException();
        }
        Node node = this.m_aNL.item(this.m_nIndex);
        ++this.m_nIndex;
        return node;
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("NodeList", (Object)this.m_aNL).append("Max", this.m_nMax).append("Index", this.m_nIndex).getToString();
    }

    @ReturnsMutableCopy
    public static @NonNull NodeListIterator createChildNodeIterator(@Nullable Node node) {
        return new NodeListIterator(node == null ? null : node.getChildNodes());
    }
}

