/*
 * Decompiled with CFR 0.152.
 */
package com.helger.wsclient;

import com.helger.annotation.OverridingMethodsMustInvokeSuper;
import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.annotation.style.OverrideOnDemand;
import com.helger.annotation.style.ReturnsMutableObject;
import com.helger.base.classloader.ClassLoaderHelper;
import com.helger.base.debug.GlobalDebug;
import com.helger.base.state.ETriState;
import com.helger.base.string.StringHelper;
import com.helger.collection.commons.CommonsArrayList;
import com.helger.collection.commons.ICommonsList;
import com.helger.http.header.HttpHeaderMap;
import com.helger.http.security.HostnameVerifierVerifyAll;
import com.helger.http.security.TrustManagerTrustAll;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.xml.ws.BindingProvider;
import jakarta.xml.ws.handler.Handler;
import jakarta.xml.ws.handler.MessageContext;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class WSClientConfig {
    public static final int DEFAULT_CONNECTION_TIMEOUT_MS = 5000;
    public static final int DEFAULT_REQUEST_TIMEOUT_MS = 5000;
    public static final int DEFAULT_CHUNK_SIZE = -1;
    private static final Logger LOGGER = LoggerFactory.getLogger(WSClientConfig.class);
    private final URL m_aEndpointAddress;
    private SSLSocketFactory m_aSSLSocketFactory;
    private HostnameVerifier m_aHostnameVerifier;
    private int m_nConnectionTimeoutMS = 5000;
    private int m_nRequestTimeoutMS = 5000;
    private int m_nChunkSize = -1;
    private String m_sUserName;
    private String m_sPassword;
    private String m_sSOAPAction;
    private final HttpHeaderMap m_aHTTPHeaders = new HttpHeaderMap();
    private ETriState m_eCookiesSupport = ETriState.UNDEFINED;
    private final ICommonsList<Handler<? extends MessageContext>> m_aHandlers = new CommonsArrayList();
    private boolean m_bWorkAroundMASM0003 = true;

    public WSClientConfig(@Nullable URL uRL) {
        this.m_aEndpointAddress = uRL;
        if (LOGGER.isDebugEnabled() && uRL != null) {
            LOGGER.debug("Using endpoint address '" + this.m_aEndpointAddress.toExternalForm() + "'");
        }
    }

    @Nullable
    public final URL getEndpointAddress() {
        return this.m_aEndpointAddress;
    }

    @Nullable
    public SSLSocketFactory getSSLSocketFactory() {
        return this.m_aSSLSocketFactory;
    }

    @Nonnull
    public final WSClientConfig setSSLSocketFactoryTrustAll() throws KeyManagementException {
        return this.setSSLSocketFactoryTrustAll(GlobalDebug.isDebugMode());
    }

    @Nonnull
    public final WSClientConfig setSSLSocketFactoryTrustAll(boolean bl) throws KeyManagementException {
        try {
            SSLContext sSLContext = SSLContext.getInstance("TLSv1.2");
            sSLContext.init(null, new TrustManager[]{new TrustManagerTrustAll(bl)}, null);
            SSLSocketFactory sSLSocketFactory = sSLContext.getSocketFactory();
            return this.setSSLSocketFactory(sSLSocketFactory);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new IllegalStateException("TLS 1.2 is not supported", noSuchAlgorithmException);
        }
    }

    @Nonnull
    public final WSClientConfig setSSLSocketFactory(@Nullable SSLSocketFactory sSLSocketFactory) {
        this.m_aSSLSocketFactory = sSLSocketFactory;
        return this;
    }

    @Nullable
    public HostnameVerifier getHostnameVerifier() {
        return this.m_aHostnameVerifier;
    }

    @Nonnull
    public final WSClientConfig setHostnameVerifierTrustAll() {
        return this.setHostnameVerifierTrustAll(GlobalDebug.isDebugMode());
    }

    @Nonnull
    public final WSClientConfig setHostnameVerifierTrustAll(boolean bl) {
        return this.setHostnameVerifier((HostnameVerifier)new HostnameVerifierVerifyAll(bl));
    }

    @Nonnull
    public final WSClientConfig setHostnameVerifier(@Nullable HostnameVerifier hostnameVerifier) {
        this.m_aHostnameVerifier = hostnameVerifier;
        return this;
    }

    public int getConnectionTimeoutMS() {
        return this.m_nConnectionTimeoutMS;
    }

    public boolean hasConnectionTimeoutMS() {
        return this.m_nConnectionTimeoutMS >= 0;
    }

    @Nonnull
    public final WSClientConfig setConnectionTimeoutMS(int n) {
        this.m_nConnectionTimeoutMS = n;
        return this;
    }

    public int getRequestTimeoutMS() {
        return this.m_nRequestTimeoutMS;
    }

    public boolean hasRequestTimeoutMS() {
        return this.m_nRequestTimeoutMS >= 0;
    }

    @Nonnull
    public final WSClientConfig setRequestTimeoutMS(int n) {
        this.m_nRequestTimeoutMS = n;
        return this;
    }

    public int getChunkSize() {
        return this.m_nChunkSize;
    }

    public boolean hasChunkSize() {
        return this.m_nChunkSize >= 0;
    }

    @Nonnull
    public final WSClientConfig setChunkSize(int n) {
        this.m_nChunkSize = n;
        return this;
    }

    @Nullable
    public String getUserName() {
        return this.m_sUserName;
    }

    public boolean hasUserName() {
        String string = this.m_sUserName;
        return StringHelper.isNotEmpty((String)string);
    }

    @Nonnull
    public final WSClientConfig setUserName(@Nullable String string) {
        this.m_sUserName = string;
        return this;
    }

    @Nullable
    public String getPassword() {
        return this.m_sPassword;
    }

    public boolean hasPassword() {
        String string = this.m_sPassword;
        return StringHelper.isNotEmpty((String)string);
    }

    @Nonnull
    public final WSClientConfig setPassword(@Nullable String string) {
        this.m_sPassword = string;
        return this;
    }

    @Nullable
    public String getSOAPAction() {
        return this.m_sSOAPAction;
    }

    public boolean hasSOAPAction() {
        String string = this.m_sSOAPAction;
        return StringHelper.isNotEmpty((String)string);
    }

    @Nonnull
    public final WSClientConfig setSOAPAction(@Nullable String string) {
        this.m_sSOAPAction = string;
        return this;
    }

    @Nonnull
    @ReturnsMutableObject
    public HttpHeaderMap httpHeaders() {
        return this.m_aHTTPHeaders;
    }

    @Nonnull
    public final WSClientConfig setCompressedRequest(boolean bl) {
        if (bl) {
            this.m_aHTTPHeaders.setHeader("Content-Encoding", "gzip");
        } else {
            this.m_aHTTPHeaders.removeHeaders("Content-Encoding");
        }
        return this;
    }

    @Nonnull
    public final WSClientConfig setCompressedResponse(boolean bl) {
        if (bl) {
            this.m_aHTTPHeaders.setHeader("Accept-Encoding", "gzip");
        } else {
            this.m_aHTTPHeaders.removeHeaders("Accept-Encoding");
        }
        return this;
    }

    public boolean isCookiesSupportEnabled() {
        return this.m_eCookiesSupport.isTrue();
    }

    @Nonnull
    public final WSClientConfig setCookiesSupportEnabled(boolean bl) {
        this.m_eCookiesSupport = ETriState.valueOf((boolean)bl);
        return this;
    }

    @Nonnull
    @ReturnsMutableObject
    public ICommonsList<Handler<? extends MessageContext>> handlers() {
        return this.m_aHandlers;
    }

    @OverrideOnDemand
    protected void customizeRequestContext(@Nonnull Map<String, Object> map) {
    }

    protected final boolean isWorkAroundMASM0003() {
        return this.m_bWorkAroundMASM0003;
    }

    protected final WSClientConfig setWorkAroundMASM0003(boolean bl) {
        this.m_bWorkAroundMASM0003 = bl;
        return this;
    }

    @OverridingMethodsMustInvokeSuper
    @OverrideOnDemand
    public void applyWSSettingsToBindingProvider(@Nonnull BindingProvider bindingProvider) {
        Object object;
        String string;
        Map map = bindingProvider.getRequestContext();
        if (this.m_aEndpointAddress != null) {
            map.put("jakarta.xml.ws.service.endpoint.address", this.m_aEndpointAddress.toExternalForm());
        }
        if (this.m_aSSLSocketFactory != null) {
            map.put("com.sun.xml.ws.transport.https.client.SSLSocketFactory", this.m_aSSLSocketFactory);
        }
        if (this.m_aHostnameVerifier != null) {
            map.put("com.sun.xml.ws.transport.https.client.hostname.verifier", this.m_aHostnameVerifier);
        }
        if (this.hasConnectionTimeoutMS()) {
            map.put("com.sun.xml.ws.connect.timeout", this.m_nConnectionTimeoutMS);
        }
        if (this.hasRequestTimeoutMS()) {
            map.put("com.sun.xml.ws.request.timeout", this.m_nRequestTimeoutMS);
        }
        if (this.hasChunkSize()) {
            map.put("com.sun.xml.ws.transport.http.client.streaming.chunk.size", this.m_nChunkSize);
        }
        if (StringHelper.isNotEmpty((String)(string = this.m_sUserName))) {
            map.put("jakarta.xml.ws.security.auth.username", this.m_sUserName);
            map.put("jakarta.xml.ws.security.auth.password", this.m_sPassword);
        }
        if (this.hasSOAPAction()) {
            map.put("jakarta.xml.ws.soap.http.soapaction.use", Boolean.TRUE);
            map.put("jakarta.xml.ws.soap.http.soapaction.uri", this.m_sSOAPAction);
        }
        if (this.m_aHTTPHeaders.isNotEmpty()) {
            map.put("jakarta.xml.ws.http.request.headers", this.m_aHTTPHeaders.getAsMapStringToListString());
        }
        if (this.m_eCookiesSupport.isDefined()) {
            map.put("jakarta.xml.ws.session.maintain", this.m_eCookiesSupport.getAsBooleanObj());
        }
        if (this.m_aHandlers.isNotEmpty()) {
            object = bindingProvider.getBinding().getHandlerChain();
            object.addAll(this.m_aHandlers);
            bindingProvider.getBinding().setHandlerChain((List)object);
        }
        this.customizeRequestContext(map);
        if (this.m_bWorkAroundMASM0003) {
            object = ClassLoaderHelper.getContextClassLoader();
            ClassLoader classLoader = this.getClass().getClassLoader();
            if (object == null) {
                LOGGER.info("Manually setting thread context class loader to work around MASM0003 bug");
                ClassLoaderHelper.setContextClassLoader((ClassLoader)classLoader);
            } else if (!object.equals(classLoader)) {
                LOGGER.warn("Manually overriding thread context class loader to work around MASM0003 bug");
                ClassLoaderHelper.setContextClassLoader((ClassLoader)classLoader);
            }
        }
    }
}

