/*
 * Decompiled with CFR 0.152.
 */
package com.helger.url;

import com.helger.annotation.Nonempty;
import com.helger.base.builder.IBuilder;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.string.StringHelper;
import com.helger.collection.commons.ICommonsList;
import com.helger.url.ISimpleURL;
import com.helger.url.ReadOnlyURL;
import com.helger.url.SimpleURLHelper;
import com.helger.url.data.IURLData;
import com.helger.url.data.URLData;
import com.helger.url.param.URLParameter;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Map;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public class URLBuilder
implements IBuilder<ISimpleURL> {
    private final URLData m_aData;

    public URLBuilder() {
        this.m_aData = URLData.createEmpty();
    }

    protected URLBuilder(@NonNull URLData uRLData) {
        this.m_aData = uRLData;
    }

    public @NonNull IURLData urlData() {
        return this.m_aData;
    }

    public @NonNull URLBuilder path(@NonNull String string) {
        this.m_aData.setPath(string);
        return this;
    }

    public @NonNull URLBuilder params(@Nullable Map<String, String> map) {
        this.m_aData.params().removeAll();
        if (map != null) {
            for (Map.Entry<String, String> entry : map.entrySet()) {
                this.addParam(entry.getKey(), entry.getValue());
            }
        }
        return this;
    }

    public @NonNull URLBuilder params(@Nullable ICommonsList<URLParameter> iCommonsList) {
        this.m_aData.setParams((ICommonsList)iCommonsList);
        return this;
    }

    public @NonNull URLBuilder addParam(@Nonempty @NonNull String string, boolean bl) {
        return this.addParam(string, Boolean.toString(bl));
    }

    public @NonNull URLBuilder addParam(@Nonempty @NonNull String string, int n) {
        return this.addParam(string, Integer.toString(n));
    }

    public @NonNull URLBuilder addParam(@Nonempty @NonNull String string, long l) {
        return this.addParam(string, Long.toString(l));
    }

    public @NonNull URLBuilder addParam(@Nonempty @NonNull String string, @Nullable String string2) {
        return this.addParam(new URLParameter(string, string2));
    }

    public @NonNull URLBuilder addParam(@NonNull URLParameter uRLParameter) {
        ValueEnforcer.notNull((Object)uRLParameter, (String)"Param");
        this.m_aData.params().add((Object)uRLParameter);
        return this;
    }

    public @NonNull URLBuilder removeParam(@Nonempty @NonNull String string) {
        this.m_aData.params().removeIf(uRLParameter -> uRLParameter.hasName(string));
        return this;
    }

    public @NonNull URLBuilder param(@Nonempty @NonNull String string, @Nullable String string2) {
        this.removeParam(string);
        return this.addParam(string, string2);
    }

    public @NonNull URLBuilder param(@NonNull URLParameter uRLParameter) {
        ValueEnforcer.notNull((Object)uRLParameter, (String)"Param");
        this.removeParam(uRLParameter.getName());
        return this.addParam(uRLParameter);
    }

    public @NonNull URLBuilder anchor(@Nullable String string) {
        this.m_aData.setAnchor(string);
        return this;
    }

    public @NonNull URLBuilder charset(@Nullable Charset charset) {
        this.m_aData.setCharset(charset);
        return this;
    }

    public @NonNull ISimpleURL build() {
        return new ReadOnlyURL(this.m_aData);
    }

    public static @NonNull URLBuilder of(@Nullable IURLData iURLData) {
        return iURLData == null ? new URLBuilder() : new URLBuilder(new URLData(iURLData));
    }

    public static @NonNull URLBuilder of(@Nullable String string) {
        if (StringHelper.isEmpty((String)string)) {
            return new URLBuilder();
        }
        return new URLBuilder(SimpleURLHelper.getAsURLData(string, URLData.DEFAULT_CHARSET));
    }

    public static @NonNull URLBuilder of(@Nullable URL uRL) {
        return URLBuilder.of(uRL == null ? null : uRL.toExternalForm());
    }

    public static @NonNull URLBuilder of(@Nullable URI uRI) {
        return URLBuilder.of(uRI == null ? null : uRI.toString());
    }
}

