/*
 * Decompiled with CFR 0.152.
 */
package com.helger.unittest.support;

import com.helger.annotation.Nonnegative;
import com.helger.annotation.concurrent.Immutable;
import com.helger.base.clone.ICloneable;
import com.helger.base.concurrent.ExecutorServiceHelper;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.equals.EqualsHelper;
import com.helger.base.iface.IThrowingRunnable;
import com.helger.base.lang.IExplicitlyCloneable;
import com.helger.base.rt.StackTraceHelper;
import com.helger.base.serialize.SerializationHelper;
import com.helger.base.string.StringImplode;
import jakarta.annotation.Nonnull;
import java.io.Serializable;
import java.util.Vector;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.junit.Assert;

@Immutable
public final class TestHelper {
    private static final TestHelper INSTANCE = new TestHelper();

    private TestHelper() {
    }

    private static <DATATYPE> void _testEqualsImplementation(@Nonnull DATATYPE DATATYPE) {
        Assert.assertNotNull((String)"Passed object may not be null!", DATATYPE);
        Assert.assertEquals((String)"Passed objects are not equal", DATATYPE, DATATYPE);
        Assert.assertNotEquals((String)"Object may no be equal to String", DATATYPE, (Object)"any string");
        Assert.assertNotEquals((String)"Object may no be equal to String", (Object)"any string", DATATYPE);
        Assert.assertNotNull((String)"Object may no be equal to null", DATATYPE);
    }

    public static <DATATYPE> void testEqualsImplementationWithEqualContentObject(@Nonnull DATATYPE DATATYPE, @Nonnull DATATYPE DATATYPE2) {
        TestHelper._testEqualsImplementation(DATATYPE);
        TestHelper._testEqualsImplementation(DATATYPE2);
        Assert.assertFalse((String)"This test may not be used with the same object!", (boolean)EqualsHelper.identityEqual(DATATYPE, DATATYPE2));
        Assert.assertEquals((String)"Passed objects are not identical!", DATATYPE, DATATYPE2);
        Assert.assertEquals((String)"Passed objects are not identical!", DATATYPE2, DATATYPE);
    }

    public static <DATATYPE> void testEqualsImplementationWithDifferentContentObject(@Nonnull DATATYPE DATATYPE, @Nonnull DATATYPE DATATYPE2) {
        TestHelper._testEqualsImplementation(DATATYPE);
        TestHelper._testEqualsImplementation(DATATYPE2);
        Assert.assertFalse((String)"This test may not be used with the same object!", (boolean)EqualsHelper.identityEqual(DATATYPE, DATATYPE2));
        Assert.assertNotEquals((String)"Passed objects are identical!", DATATYPE, DATATYPE2);
        Assert.assertNotEquals((String)"Passed objects are identical!", DATATYPE2, DATATYPE);
    }

    private static <DATATYPE> void _testHashCodeImplementation(@Nonnull DATATYPE DATATYPE) {
        Assert.assertNotNull((String)"Passed object may not be null!", DATATYPE);
        Assert.assertEquals((String)"hashCode() invocations must be consistent", (long)DATATYPE.hashCode(), (long)DATATYPE.hashCode());
        Assert.assertNotEquals((String)"hashCode() may not be 0", (long)DATATYPE.hashCode(), (long)0L);
    }

    public static <DATATYPE> void testHashCodeImplementationWithEqualContentObject(@Nonnull DATATYPE DATATYPE, @Nonnull DATATYPE DATATYPE2) {
        TestHelper._testHashCodeImplementation(DATATYPE);
        TestHelper._testHashCodeImplementation(DATATYPE2);
        Assert.assertEquals((String)"Passed objects are not identical!", DATATYPE, DATATYPE2);
        Assert.assertFalse((String)"This test may not be used with the same object!", (boolean)EqualsHelper.identityEqual(DATATYPE, DATATYPE2));
        Assert.assertEquals((String)"hashCode() invocations must be consistent", (long)DATATYPE.hashCode(), (long)DATATYPE2.hashCode());
        Assert.assertEquals((String)"hashCode() invocations must be consistent", (long)DATATYPE2.hashCode(), (long)DATATYPE.hashCode());
    }

    public static <DATATYPE> void testHashCodeImplementationWithDifferentContentObject(@Nonnull DATATYPE DATATYPE, @Nonnull DATATYPE DATATYPE2) {
        TestHelper._testHashCodeImplementation(DATATYPE);
        TestHelper._testHashCodeImplementation(DATATYPE2);
        Assert.assertNotEquals((String)"Passed objects are identical!", DATATYPE, DATATYPE2);
        Assert.assertFalse((String)"This test may not be used with the same object!", (boolean)EqualsHelper.identityEqual(DATATYPE, DATATYPE2));
        int n = DATATYPE.hashCode();
        int n2 = DATATYPE2.hashCode();
        Assert.assertNotEquals((String)"hashCode() may not be the same for both objects", (long)n, (long)n2);
    }

    public static void testToStringImplementation(@Nonnull Object object) {
        Assert.assertNotNull((String)"Passed object may not be null!", (Object)object);
        Assert.assertNotNull((String)"toString() may not return null!", (Object)object.toString());
        Assert.assertTrue((String)"toString() may not return an empty string!", (object.toString().length() > 0 ? 1 : 0) != 0);
        Assert.assertEquals((String)"toString() invocations must be consistent", (Object)object.toString(), (Object)object.toString());
    }

    public static <DATATYPE> void testToStringImplementationWithEqualContentObject(@Nonnull DATATYPE DATATYPE, @Nonnull DATATYPE DATATYPE2) {
        TestHelper.testToStringImplementation(DATATYPE);
        TestHelper.testToStringImplementation(DATATYPE2);
        Assert.assertEquals((String)"Passed objects are not identical!", DATATYPE, DATATYPE2);
        Assert.assertFalse((String)"This test may not be used with the same object!", (boolean)EqualsHelper.identityEqual(DATATYPE, DATATYPE2));
    }

    public static <DATATYPE> void testToStringImplementationWithDifferentContentObject(@Nonnull DATATYPE DATATYPE, @Nonnull DATATYPE DATATYPE2) {
        TestHelper.testToStringImplementation(DATATYPE);
        TestHelper.testToStringImplementation(DATATYPE2);
        Assert.assertNotEquals((String)"Passed objects are identical!", DATATYPE, DATATYPE2);
        Assert.assertFalse((String)"This test may not be used with the same object!", (boolean)EqualsHelper.identityEqual(DATATYPE, DATATYPE2));
    }

    public static <DATATYPE> void testDefaultImplementationWithEqualContentObject(@Nonnull DATATYPE DATATYPE, @Nonnull DATATYPE DATATYPE2) {
        TestHelper.testEqualsImplementationWithEqualContentObject(DATATYPE, DATATYPE2);
        TestHelper.testHashCodeImplementationWithEqualContentObject(DATATYPE, DATATYPE2);
        TestHelper.testToStringImplementationWithEqualContentObject(DATATYPE, DATATYPE2);
    }

    public static <DATATYPE> void testDefaultImplementationWithDifferentContentObject(@Nonnull DATATYPE DATATYPE, @Nonnull DATATYPE DATATYPE2) {
        TestHelper.testEqualsImplementationWithDifferentContentObject(DATATYPE, DATATYPE2);
        TestHelper.testHashCodeImplementationWithDifferentContentObject(DATATYPE, DATATYPE2);
        TestHelper.testToStringImplementationWithDifferentContentObject(DATATYPE, DATATYPE2);
    }

    public static void testGetClone(@Nonnull ICloneable<?> iCloneable) {
        Object object = iCloneable.getClone();
        Assert.assertNotNull((String)"Clone returned a null object", (Object)object);
        Assert.assertEquals((String)"Clone returned a different class than the original one", object.getClass(), (Object)iCloneable.getClass());
        TestHelper.testDefaultImplementationWithEqualContentObject(iCloneable, object);
    }

    public static void testClone(@Nonnull IExplicitlyCloneable iExplicitlyCloneable) {
        try {
            Object object = iExplicitlyCloneable.clone();
            Assert.assertNotNull((String)"Clone returned a null object", (Object)object);
            Assert.assertEquals((String)"Clone returned a different class than the original one", object.getClass(), (Object)iExplicitlyCloneable.getClass());
            TestHelper.testDefaultImplementationWithEqualContentObject(iExplicitlyCloneable, object);
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new IllegalStateException("Clone not supported", cloneNotSupportedException);
        }
    }

    @Nonnull
    public static <DATATYPE extends Serializable> DATATYPE testDefaultSerialization(@Nonnull DATATYPE DATATYPE) {
        byte[] byArray = SerializationHelper.getSerializedByteArray(DATATYPE);
        Serializable serializable = (Serializable)SerializationHelper.getDeserializedObject((byte[])byArray);
        TestHelper.testDefaultImplementationWithEqualContentObject(DATATYPE, serializable);
        return (DATATYPE)serializable;
    }

    public static void testInParallel(@Nonnegative int n, @Nonnull IThrowingRunnable<? extends Exception> iThrowingRunnable) {
        ValueEnforcer.isGE0((int)n, (String)"Calls");
        ValueEnforcer.notNull(iThrowingRunnable, (String)"Runnable");
        ExecutorService executorService = Executors.newFixedThreadPool(20);
        Vector vector = new Vector();
        for (int i = 0; i < n; ++i) {
            executorService.submit(() -> {
                try {
                    iThrowingRunnable.run();
                }
                catch (Exception exception) {
                    vector.add(exception.getMessage() + "\n" + StackTraceHelper.getStackAsString((Throwable)exception));
                }
            });
        }
        ExecutorServiceHelper.shutdownAndWaitUntilAllTasksAreFinished((ExecutorService)executorService);
        if (!vector.isEmpty()) {
            Assert.fail((String)StringImplode.getImploded(vector));
        }
    }
}

