/*
 * Decompiled with CFR 0.152.
 */
package com.helger.unittestext;

import com.helger.annotation.style.IsSPIImplementation;
import com.helger.annotation.style.IsSPIInterface;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.io.nonblocking.NonBlockingBufferedReader;
import com.helger.base.io.stream.StreamHelper;
import com.helger.base.lang.clazz.ClassHelper;
import com.helger.base.string.StringHelper;
import com.helger.collection.commons.CommonsTreeMap;
import com.helger.collection.commons.CommonsTreeSet;
import com.helger.collection.commons.ICommonsSortedMap;
import com.helger.collection.commons.ICommonsSortedSet;
import com.helger.io.file.FileHelper;
import com.helger.io.file.FileSystemIterator;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.jspecify.annotations.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SPITestHelper {
    public static final String TEST_SERVICES = "src/test/resources/META-INF/services";
    public static final String MAIN_SERVICES = "src/main/resources/META-INF/services";
    private static final Logger LOGGER = LoggerFactory.getLogger(SPITestHelper.class);

    private SPITestHelper() {
    }

    @ReturnsMutableCopy
    public static @NonNull ICommonsSortedMap<String, ICommonsSortedSet<String>> testIfAllSPIImplementationsAreValid(@NonNull String string2, @NonNull EMode eMode) throws IOException {
        ValueEnforcer.notNull((Object)string2, (String)"BaseDir");
        ValueEnforcer.notNull((Object)((Object)eMode), (String)"Mode");
        boolean bl = eMode.isResolve();
        ClassLoader classLoader = StackWalker.getInstance(StackWalker.Option.RETAIN_CLASS_REFERENCE).getCallerClass().getClassLoader();
        CommonsTreeMap commonsTreeMap = new CommonsTreeMap();
        File file = new File(string2);
        if (file.exists() && file.isDirectory()) {
            for (File file2 : new FileSystemIterator(string2)) {
                NonBlockingBufferedReader nonBlockingBufferedReader;
                String string3;
                block18: {
                    if (!file2.isFile()) continue;
                    if (bl) {
                        LOGGER.info("Checking SPI file " + file2.getAbsolutePath());
                    }
                    string3 = file2.getName();
                    if (bl) {
                        try {
                            nonBlockingBufferedReader = classLoader.loadClass(string3);
                            if (string3.startsWith("com.helger.") && nonBlockingBufferedReader.getAnnotation(IsSPIInterface.class) == null) {
                                LOGGER.warn(String.valueOf(nonBlockingBufferedReader) + " should have the @IsSPIInterface annotation");
                            }
                        }
                        catch (Exception exception) {
                            String string4 = "No interface representing " + string3 + " exists: " + ClassHelper.getClassLocalName((Object)exception) + " - " + exception.getMessage();
                            LOGGER.warn(string4);
                            if (!eMode.isStrict()) break block18;
                            throw new IllegalStateException(string4);
                        }
                    }
                }
                nonBlockingBufferedReader = new NonBlockingBufferedReader((Reader)StreamHelper.createReader((InputStream)FileHelper.getInputStream((File)file2), (Charset)StandardCharsets.UTF_8));
                try {
                    String string5;
                    int n = 0;
                    while ((string5 = nonBlockingBufferedReader.readLine()) != null) {
                        String string6 = StringHelper.trim((String)string5);
                        if (!StringHelper.isNotEmpty((String)string6)) continue;
                        if (bl) {
                            try {
                                Class<?> clazz = classLoader.loadClass(string6);
                                if (clazz.getAnnotation(IsSPIImplementation.class) == null) {
                                    LOGGER.warn(String.valueOf(clazz) + " should have the @IsSPIImplementation annotation");
                                }
                                ++n;
                                ((ICommonsSortedSet)commonsTreeMap.computeIfAbsent((Object)string3, string -> new CommonsTreeSet())).add((Object)string6);
                                continue;
                            }
                            catch (Exception exception) {
                                LOGGER.warn("  Error checking content: " + exception.getMessage());
                                if (!eMode.isStrict()) continue;
                                throw new IllegalStateException("Error checking SPI file " + file2.getAbsolutePath(), exception);
                            }
                        }
                        ++n;
                        ((ICommonsSortedSet)commonsTreeMap.computeIfAbsent((Object)string3, string -> new CommonsTreeSet())).add((Object)string6);
                    }
                    if (!bl) continue;
                    if (n == 0) {
                        LOGGER.warn("  Contains no single valid implementation!");
                        continue;
                    }
                    LOGGER.info("  All implementations (" + n + ") are valid!");
                }
                finally {
                    nonBlockingBufferedReader.close();
                }
            }
        }
        return commonsTreeMap;
    }

    @ReturnsMutableCopy
    public static @NonNull ICommonsSortedMap<String, ICommonsSortedSet<String>> testIfAllMainSPIImplementationsAreValid(boolean bl) throws IOException {
        return SPITestHelper.testIfAllSPIImplementationsAreValid(MAIN_SERVICES, bl ? EMode.IGNORE_ERRORS : EMode.STRICT);
    }

    @ReturnsMutableCopy
    public static @NonNull ICommonsSortedMap<String, ICommonsSortedSet<String>> testIfAllTestSPIImplementationsAreValid(boolean bl) throws IOException {
        return SPITestHelper.testIfAllSPIImplementationsAreValid(TEST_SERVICES, bl ? EMode.IGNORE_ERRORS : EMode.STRICT);
    }

    @ReturnsMutableCopy
    public static @NonNull ICommonsSortedMap<String, ICommonsSortedSet<String>> testIfAllSPIImplementationsAreValid(boolean bl) throws IOException {
        ICommonsSortedMap<String, ICommonsSortedSet<String>> iCommonsSortedMap = SPITestHelper.testIfAllMainSPIImplementationsAreValid(bl);
        iCommonsSortedMap.putAll(SPITestHelper.testIfAllTestSPIImplementationsAreValid(bl));
        return iCommonsSortedMap;
    }

    @ReturnsMutableCopy
    public static @NonNull ICommonsSortedMap<String, ICommonsSortedSet<String>> testIfAllSPIImplementationsAreValid() throws IOException {
        return SPITestHelper.testIfAllSPIImplementationsAreValid(false);
    }

    public static enum EMode {
        STRICT,
        IGNORE_ERRORS,
        NO_RESOLVE;


        public boolean isStrict() {
            return this == STRICT;
        }

        public boolean isResolve() {
            return this != NO_RESOLVE;
        }
    }
}

