/*
 * Decompiled with CFR 0.152.
 */
package com.helger.tree.io;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.io.file.FileHelper;
import com.helger.commons.io.file.FilenameHelper;
import com.helger.commons.string.StringHelper;
import com.helger.tree.withid.folder.DefaultFolderTree;
import com.helger.tree.withid.folder.DefaultFolderTreeItem;
import java.io.File;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class FileSystemFolderTree
extends DefaultFolderTree<String, File, ICommonsList<File>> {
    private static void _iterate(@Nonnull DefaultFolderTreeItem<String, File, ICommonsList<File>> defaultFolderTreeItem, @Nonnull File file, @Nullable Predicate<? super File> predicate, @Nullable Predicate<? super File> predicate2) {
        for (File file2 : FileHelper.getDirectoryContent((File)file)) {
            if (file2.isFile()) {
                if (predicate2 != null && !predicate2.test(file2)) continue;
                ((ICommonsList)defaultFolderTreeItem.getData()).add((Object)file2);
                continue;
            }
            if (!file2.isDirectory() || FilenameHelper.isSystemInternalDirectory((File)file2) || predicate != null && !predicate.test(file2)) continue;
            DefaultFolderTreeItem defaultFolderTreeItem2 = (DefaultFolderTreeItem)defaultFolderTreeItem.createChildItem(file2.getName(), (File)new CommonsArrayList());
            FileSystemFolderTree._iterate(defaultFolderTreeItem2, file2, predicate, predicate2);
        }
    }

    public FileSystemFolderTree(@Nonnull String string) {
        this(new File(string));
    }

    public FileSystemFolderTree(@Nonnull File file) {
        this(file, (Predicate<? super File>)null, (Predicate<? super File>)null);
    }

    public FileSystemFolderTree(@Nonnull String string, @Nullable Predicate<? super File> predicate, @Nullable Predicate<? super File> predicate2) {
        this(new File(string), predicate, predicate2);
    }

    public FileSystemFolderTree(@Nonnull File file, @Nullable Predicate<? super File> predicate, @Nullable Predicate<? super File> predicate2) {
        super(collection -> StringHelper.getImplodedNonEmpty((char)'/', (Iterable)collection));
        ValueEnforcer.notNull((Object)file, (String)"StartDirectory");
        ValueEnforcer.isTrue((boolean)file.isDirectory(), (String)"Start directory is not a directory!");
        DefaultFolderTreeItem defaultFolderTreeItem = (DefaultFolderTreeItem)((DefaultFolderTreeItem)this.getRootItem()).createChildItem(file.getName(), new CommonsArrayList());
        FileSystemFolderTree._iterate(defaultFolderTreeItem, file, predicate, predicate2);
    }
}

