/*
 * Decompiled with CFR 0.152.
 */
package com.helger.text.resolve;

import com.helger.annotation.Nonempty;
import com.helger.annotation.PropertyKey;
import com.helger.annotation.concurrent.GuardedBy;
import com.helger.annotation.concurrent.ThreadSafe;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.concurrent.SimpleReadWriteLock;
import com.helger.base.debug.GlobalDebug;
import com.helger.collection.commons.CommonsHashMap;
import com.helger.collection.commons.CommonsHashSet;
import com.helger.collection.commons.ICommonsMap;
import com.helger.collection.commons.ICommonsSet;
import com.helger.statistics.api.IMutableStatisticsHandlerKeyedCounter;
import com.helger.statistics.impl.StatisticsManager;
import com.helger.text.locale.LocaleHelper;
import com.helger.text.resolve.AbstractEnumTextResolverWithOverrideAndFallback;
import com.helger.text.resourcebundle.ResourceBundleHelper;
import java.util.Locale;
import java.util.ResourceBundle;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class EnumTextResolverWithPropertiesOverrideAndFallback
extends AbstractEnumTextResolverWithOverrideAndFallback {
    public static final String PREFIX_OVERRIDE = "properties/override-";
    public static final String PREFIX_FALLBACK = "properties/";
    public static final boolean DEFAULT_USE_RESOURCE_BUNDLE_CACHE = true;
    private static final Logger LOGGER = LoggerFactory.getLogger(EnumTextResolverWithPropertiesOverrideAndFallback.class);
    private static final IMutableStatisticsHandlerKeyedCounter STATS_FAILED = StatisticsManager.getKeyedCounterHandler((String)(EnumTextResolverWithPropertiesOverrideAndFallback.class.getName() + "$failed"));
    private final SimpleReadWriteLock m_aRWLock = new SimpleReadWriteLock();
    @GuardedBy(value="m_aRWLock")
    private final ICommonsSet<String> m_aUsedOverrideBundles = new CommonsHashSet();
    @GuardedBy(value="m_aRWLock")
    private final ICommonsSet<String> m_aUsedFallbackBundles = new CommonsHashSet();
    @GuardedBy(value="m_aRWLock")
    private boolean m_bUseResourceBundleCache = true;
    @GuardedBy(value="m_aRWLock")
    private final ICommonsMap<String, ResourceBundle> m_aResourceBundleCache = new CommonsHashMap();

    public void setUseResourceBundleCache(boolean bl) {
        this.m_aRWLock.writeLocked(() -> {
            this.m_bUseResourceBundleCache = bl;
        });
    }

    public boolean isUseResourceBundleCache() {
        return this.m_aRWLock.readLockedBoolean(() -> this.m_bUseResourceBundleCache);
    }

    private @Nullable ResourceBundle _getResourceBundle(@NonNull @Nonempty String string, @NonNull Locale locale) {
        ResourceBundle resourceBundle = (ResourceBundle)this.m_aRWLock.readLockedGet(() -> {
            if (!this.m_bUseResourceBundleCache) {
                return ResourceBundleHelper.getResourceBundle(string, locale);
            }
            if (this.m_aResourceBundleCache.containsKey((Object)string)) {
                return (ResourceBundle)this.m_aResourceBundleCache.get((Object)string);
            }
            return null;
        });
        if (resourceBundle == null) {
            resourceBundle = (ResourceBundle)this.m_aRWLock.writeLockedGet(() -> {
                if (this.m_aResourceBundleCache.containsKey((Object)string)) {
                    return (ResourceBundle)this.m_aResourceBundleCache.get((Object)string);
                }
                ResourceBundle resourceBundle = ResourceBundleHelper.getResourceBundle(string, locale);
                this.m_aResourceBundleCache.put((Object)string, (Object)resourceBundle);
                return resourceBundle;
            });
        }
        return resourceBundle;
    }

    @Override
    protected @Nullable String internalGetOverrideString(@PropertyKey @NonNull String string, @NonNull Locale locale) {
        for (Locale locale2 : LocaleHelper.getCalculatedLocaleListForResolving(locale)) {
            String string2 = PREFIX_OVERRIDE + locale2.toString();
            String string3 = ResourceBundleHelper.getString(this._getResourceBundle(string2, locale2), string);
            if (string3 == null) continue;
            this.m_aRWLock.writeLocked(() -> this.m_aUsedOverrideBundles.add((Object)string2));
            return string3;
        }
        return null;
    }

    @Override
    protected @Nullable String internalGetFallbackString(@PropertyKey @NonNull String string, @NonNull Locale locale) {
        for (Locale locale2 : LocaleHelper.getCalculatedLocaleListForResolving(locale)) {
            String string2 = PREFIX_FALLBACK + locale2.toString();
            String string3 = ResourceBundleHelper.getString(this._getResourceBundle(string2, locale2), string);
            if (string3 == null) continue;
            this.m_aRWLock.writeLocked(() -> this.m_aUsedFallbackBundles.add((Object)string2));
            return string3;
        }
        STATS_FAILED.increment(PREFIX_FALLBACK + locale.toString() + ":" + string);
        if (GlobalDebug.isDebugMode()) {
            LOGGER.warn("getFallbackString (" + string + "; " + locale.toString() + ") failed!");
        }
        return null;
    }

    @ReturnsMutableCopy
    public @NonNull ICommonsSet<String> getAllUsedOverrideBundleNames() {
        return (ICommonsSet)this.m_aRWLock.readLockedGet(() -> this.m_aUsedOverrideBundles.getClone());
    }

    @ReturnsMutableCopy
    public @NonNull ICommonsSet<String> getAllUsedFallbackBundleNames() {
        return (ICommonsSet)this.m_aRWLock.readLockedGet(() -> this.m_aUsedFallbackBundles.getClone());
    }

    public void clearCache() {
        this.m_aRWLock.writeLocked(() -> {
            ResourceBundleHelper.clearCache();
            this.m_aUsedOverrideBundles.clear();
            this.m_aUsedFallbackBundles.clear();
            this.m_aResourceBundleCache.clear();
        });
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Cache was cleared: " + this.getClass().getName());
        }
    }
}

