/*
 * Decompiled with CFR 0.152.
 */
package com.helger.text.locale;

import com.helger.annotation.concurrent.GuardedBy;
import com.helger.annotation.concurrent.ThreadSafe;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.concurrent.SimpleReadWriteLock;
import com.helger.base.log.ConditionalLogger;
import com.helger.base.log.IHasConditionalLogger;
import com.helger.base.string.StringHelper;
import com.helger.collection.commons.CommonsHashSet;
import com.helger.collection.commons.CommonsLinkedHashMap;
import com.helger.collection.commons.CommonsLinkedHashSet;
import com.helger.collection.commons.ICommonsList;
import com.helger.collection.commons.ICommonsOrderedMap;
import com.helger.collection.commons.ICommonsOrderedSet;
import com.helger.collection.commons.ICommonsSet;
import com.helger.text.locale.LocaleHelper;
import java.util.Locale;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class LocaleCache
implements IHasConditionalLogger {
    private static final Logger LOGGER = LoggerFactory.getLogger(LocaleCache.class);
    private static final ConditionalLogger CONDLOG = new ConditionalLogger(LOGGER);
    private static boolean s_bDefaultInstantiated = false;
    private final SimpleReadWriteLock m_aRWLock = new SimpleReadWriteLock();
    @GuardedBy(value="m_aRWLock")
    private final ICommonsOrderedMap<String, Locale> m_aLocales = new CommonsLinkedHashMap();
    private final IMissingLocaleHandler m_aMissingLocaleHandlerInsert = (string, string2, string3, string4) -> {
        if (StringHelper.isEmpty((String)string)) {
            return null;
        }
        return (Locale)this.m_aRWLock.writeLockedGet(() -> (Locale)this.m_aLocales.computeIfAbsent((Object)string, string4 -> new Locale(string2, string3, string4)));
    };

    protected LocaleCache() {
        this.reinitialize();
    }

    public static boolean isSilentMode() {
        return CONDLOG.isDisabled();
    }

    public static boolean setSilentMode(boolean bl) {
        return !CONDLOG.setEnabled(!bl);
    }

    public static boolean isInstantiated() {
        return s_bDefaultInstantiated;
    }

    public static @NonNull LocaleCache getInstance() {
        LocaleCache localeCache = SingletonHolder.INSTANCE;
        s_bDefaultInstantiated = true;
        return localeCache;
    }

    public final @NonNull IMissingLocaleHandler getDefaultMissingLocaleHandler() {
        return this.m_aMissingLocaleHandlerInsert;
    }

    public @Nullable Locale getLocale(@Nullable String string) {
        return this.getLocaleExt(string, this.m_aMissingLocaleHandlerInsert);
    }

    public @Nullable Locale getLocaleExt(@Nullable String string, @Nullable IMissingLocaleHandler iMissingLocaleHandler) {
        if (string != null && string.length() > 2) {
            String[] stringArray = StringHelper.getExplodedArray((char)'_', (String)string, (int)3);
            if (stringArray.length == 3) {
                return this.getLocale(stringArray[0], stringArray[1], stringArray[2], iMissingLocaleHandler);
            }
            if (stringArray.length == 2) {
                return this.getLocale(stringArray[0], stringArray[1], "", iMissingLocaleHandler);
            }
        }
        return this.getLocale(string, "", "", iMissingLocaleHandler);
    }

    public @Nullable Locale getLocale(@Nullable String string, @Nullable String string2) {
        return this.getLocale(string, string2, "");
    }

    public @Nullable Locale getLocale(@Nullable String string, @Nullable String string2, @Nullable String string3) {
        return this.getLocale(string, string2, string3, this.m_aMissingLocaleHandlerInsert);
    }

    private static @NonNull String _buildLocaleString(@NonNull String string, @NonNull String string2, @NonNull String string3) {
        StringBuilder stringBuilder = new StringBuilder();
        if (string.length() > 0) {
            stringBuilder.append(string);
        }
        if (string2.length() > 0) {
            stringBuilder.append('_').append(string2);
        }
        if (string3.length() > 0) {
            stringBuilder.append('_').append(string3);
        }
        return stringBuilder.toString();
    }

    public @Nullable Locale getLocale(@Nullable String string, @Nullable String string2, @Nullable String string3, @Nullable IMissingLocaleHandler iMissingLocaleHandler) {
        String string4 = StringHelper.getNotNull((String)LocaleHelper.getValidLanguageCode(string));
        String string5 = StringHelper.getNotNull((String)LocaleHelper.getValidCountryCode(string2));
        String string6 = StringHelper.getNotNull((String)string3);
        String string7 = LocaleCache._buildLocaleString(string4, string5, string6);
        Locale locale = null;
        if (string7.length() > 0) {
            locale = (Locale)this.m_aRWLock.readLockedGet(() -> (Locale)this.m_aLocales.get((Object)string7));
        }
        if (locale == null && iMissingLocaleHandler != null) {
            locale = iMissingLocaleHandler.onMissingLocale(string7, string4, string5, string6);
        }
        return locale;
    }

    @ReturnsMutableCopy
    public @NonNull ICommonsList<Locale> getAllLocales() {
        ICommonsList iCommonsList = (ICommonsList)this.m_aRWLock.readLockedGet(() -> this.m_aLocales.copyOfValues());
        iCommonsList.remove((Object)LocaleHelper.LOCALE_ALL);
        iCommonsList.remove((Object)LocaleHelper.LOCALE_INDEPENDENT);
        return iCommonsList;
    }

    @ReturnsMutableCopy
    public @NonNull ICommonsSet<Locale> getAllLanguages() {
        CommonsHashSet commonsHashSet = new CommonsHashSet();
        for (Locale locale : this.getAllLocales()) {
            String string = locale.getLanguage();
            if (!StringHelper.isNotEmpty((String)string)) continue;
            commonsHashSet.add((Object)this.getLocale(string, null, null));
        }
        return commonsHashSet;
    }

    public boolean containsLocale(@Nullable String string) {
        if (string != null && string.length() > 2) {
            String[] stringArray = StringHelper.getExplodedArray((char)'_', (String)string, (int)3);
            if (stringArray.length == 3) {
                return this.containsLocale(stringArray[0], stringArray[1], stringArray[2]);
            }
            if (stringArray.length == 2) {
                return this.containsLocale(stringArray[0], stringArray[1], "");
            }
        }
        return this.containsLocale(string, "", "");
    }

    public boolean containsLocale(@Nullable String string, @Nullable String string2) {
        return this.containsLocale(string, string2, "");
    }

    private static @NonNull String _createLocaleKey(@Nullable String string, @Nullable String string2, @Nullable String string3) {
        String string4 = StringHelper.getNotNull((String)LocaleHelper.getValidLanguageCode(string));
        String string5 = StringHelper.getNotNull((String)LocaleHelper.getValidCountryCode(string2));
        String string6 = StringHelper.getNotNull((String)string3);
        return LocaleCache._buildLocaleString(string4, string5, string6);
    }

    public boolean containsLocale(@Nullable String string, @Nullable String string2, @Nullable String string3) {
        String string4 = LocaleCache._createLocaleKey(string, string2, string3);
        if (string4.length() == 0) {
            return false;
        }
        return this.m_aRWLock.readLockedBoolean(() -> this.m_aLocales.containsKey((Object)string4));
    }

    @ReturnsMutableCopy
    public static @NonNull ICommonsOrderedSet<Locale> getAllDefaultLocales() {
        CommonsLinkedHashSet commonsLinkedHashSet = new CommonsLinkedHashSet(1024);
        commonsLinkedHashSet.add((Object)LocaleHelper.LOCALE_ALL);
        commonsLinkedHashSet.add((Object)LocaleHelper.LOCALE_INDEPENDENT);
        for (Locale object : Locale.getAvailableLocales()) {
            commonsLinkedHashSet.add((Object)object);
            String string = object.getCountry();
            String string2 = object.getLanguage();
            if (!StringHelper.isNotEmpty((String)string) || !StringHelper.isNotEmpty((String)string2)) continue;
            commonsLinkedHashSet.add((Object)new Locale("", string));
            commonsLinkedHashSet.add((Object)new Locale(string2, ""));
        }
        for (String string : Locale.getISOCountries()) {
            commonsLinkedHashSet.add((Object)new Locale("", string));
        }
        for (String string : Locale.getISOLanguages()) {
            commonsLinkedHashSet.add((Object)new Locale(string, ""));
        }
        return commonsLinkedHashSet;
    }

    public final void reinitialize() {
        ICommonsOrderedSet<Locale> iCommonsOrderedSet = LocaleCache.getAllDefaultLocales();
        this.m_aRWLock.writeLocked(() -> {
            this.m_aLocales.clear();
            for (Locale locale : iCommonsOrderedSet) {
                this.m_aLocales.put((Object)locale.toString(), (Object)locale);
            }
        });
        CONDLOG.debug(() -> "Reinitialized " + LocaleCache.class.getName());
    }

    @FunctionalInterface
    public static interface IMissingLocaleHandler {
        public @Nullable Locale onMissingLocale(@NonNull String var1, @NonNull String var2, @NonNull String var3, @NonNull String var4);
    }

    private static final class SingletonHolder {
        private static final LocaleCache INSTANCE = new LocaleCache();

        private SingletonHolder() {
        }
    }
}

