/*
 * Decompiled with CFR 0.152.
 */
package com.helger.text.compare;

import com.helger.annotation.concurrent.Immutable;
import com.helger.base.compare.CompareHelper;
import com.helger.base.compare.IComparator;
import com.helger.text.compare.CollatorHelper;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.Serializable;
import java.text.Collator;
import java.util.Comparator;
import java.util.Locale;
import java.util.function.Function;

@Immutable
public final class ComparatorHelper {
    private ComparatorHelper() {
    }

    @Nonnull
    public static Comparator<String> getComparatorCollating(@Nullable Locale locale) {
        return ComparatorHelper.getComparatorCollating(CollatorHelper.getCollatorSpaceBeforeDot(locale));
    }

    @Nonnull
    public static Comparator<String> getComparatorCollating(@Nonnull Collator collator) {
        return Comparator.nullsFirst(collator::compare);
    }

    @Nonnull
    public static <T> Comparator<T> getComparatorCollating(@Nonnull Function<? super T, String> function, @Nullable Locale locale) {
        return Comparator.comparing(function, ComparatorHelper.getComparatorCollating(locale));
    }

    @Nonnull
    public static <T> Comparator<T> getComparatorCollating(@Nonnull Function<? super T, String> function, @Nonnull Collator collator) {
        return Comparator.comparing(function, ComparatorHelper.getComparatorCollating(collator));
    }

    @Nonnull
    public static IComparator<String> getComparatorStringLongestFirst() {
        return ComparatorHelper.getComparatorStringLongestFirst(true);
    }

    @Nonnull
    public static IComparator<String> getComparatorStringLongestFirst(boolean bl) {
        return (IComparator & Serializable)(string3, string4) -> CompareHelper.compare((Object)string3, (Object)string4, (string, string2) -> {
            int n = string2.length() - string.length();
            return n != 0 ? n : string.compareTo((String)string2);
        }, (boolean)bl);
    }

    @Nonnull
    public static IComparator<String> getComparatorStringShortestFirst() {
        return ComparatorHelper.getComparatorStringShortestFirst(true);
    }

    @Nonnull
    public static IComparator<String> getComparatorStringShortestFirst(boolean bl) {
        return (IComparator & Serializable)(string3, string4) -> CompareHelper.compare((Object)string3, (Object)string4, (string, string2) -> {
            int n = string.length() - string2.length();
            return n != 0 ? n : string.compareTo((String)string2);
        }, (boolean)bl);
    }

    @Nonnull
    public static IComparator<String> getComparatorStringIgnoreCase() {
        return ComparatorHelper.getComparatorStringIgnoreCase(true);
    }

    @Nonnull
    public static IComparator<String> getComparatorStringIgnoreCase(boolean bl) {
        return (IComparator & Serializable)(string, string2) -> CompareHelper.compareIgnoreCase((String)string, (String)string2, (boolean)bl);
    }
}

