/*
 * Decompiled with CFR 0.152.
 */
package com.helger.text.locale;

import com.helger.annotation.concurrent.Immutable;
import com.helger.annotation.style.CodingStyleguideUnaware;
import com.helger.annotation.style.ReturnsImmutableObject;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.equals.EqualsHelper;
import com.helger.base.state.EChange;
import com.helger.base.string.StringHelper;
import com.helger.base.system.SystemHelper;
import com.helger.cache.impl.Cache;
import com.helger.cache.regex.RegExHelper;
import com.helger.collection.commons.CommonsArrayList;
import com.helger.collection.commons.CommonsHashMap;
import com.helger.collection.commons.ICommonsMap;
import com.helger.text.locale.ELocaleName;
import com.helger.text.locale.LocaleCache;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.function.Function;

@Immutable
public final class LocaleHelper {
    public static final char LOCALE_SEPARATOR = '_';
    public static final String STR_ALL = "all";
    public static final Locale LOCALE_ALL = new Locale("all", "", "");
    public static final String STR_INDEPENDENT = "independent";
    public static final Locale LOCALE_INDEPENDENT = new Locale("independent", "", "");
    private static final String LOCALE_ALL_STR = LOCALE_ALL.toString();
    private static final String LOCALE_INDEPENDENT_STR = LOCALE_INDEPENDENT.toString();
    private static final Cache<Locale, List<Locale>> LOCALE_LIST_CACHE;
    private static final ICommonsMap<String, String> COUNTRY_ISO3TO2;
    private static final LocaleHelper INSTANCE;

    private LocaleHelper() {
    }

    public static boolean equalLocales(@Nonnull Locale locale3, @Nonnull Locale locale4) {
        return EqualsHelper.equalsCustom((Object)locale3, (Object)locale4, (locale, locale2) -> locale.toString().equals(locale2.toString()));
    }

    @Nonnull
    public static String getLocaleDisplayName(@Nullable Locale locale, @Nonnull Locale locale2) {
        ValueEnforcer.notNull((Object)locale2, (String)"ContentLocale");
        if (locale == null || locale.equals(LOCALE_INDEPENDENT)) {
            return ELocaleName.ID_LANGUAGE_INDEPENDENT.getDisplayText(locale2);
        }
        if (locale.equals(LOCALE_ALL)) {
            return ELocaleName.ID_LANGUAGE_ALL.getDisplayText(locale2);
        }
        return locale.getDisplayName(locale2);
    }

    @Nonnull
    public static String getLocaleNativeDisplayName(@Nonnull Locale locale) {
        ValueEnforcer.notNull((Object)locale, (String)"Locale");
        return LocaleHelper.getLocaleDisplayName(locale, locale);
    }

    @Nonnull
    @ReturnsMutableCopy
    public static ICommonsMap<Locale, String> getAllLocaleDisplayNames(@Nonnull Locale locale) {
        ValueEnforcer.notNull((Object)locale, (String)"ContentLocale");
        return new CommonsHashMap(LocaleCache.getInstance().getAllLocales(), Function.identity(), locale2 -> LocaleHelper.getLocaleDisplayName(locale2, locale));
    }

    @Nonnull
    @ReturnsImmutableObject
    @CodingStyleguideUnaware
    public static List<Locale> getCalculatedLocaleListForResolving(@Nonnull Locale locale) {
        ValueEnforcer.notNull((Object)locale, (String)"Locale");
        return (List)LOCALE_LIST_CACHE.getFromCache((Object)locale);
    }

    @Nonnull
    public static Locale getLocaleFromString(@Nullable String string) {
        String string2;
        String string3;
        String string4;
        if (StringHelper.isEmpty((String)string)) {
            return SystemHelper.getSystemLocale();
        }
        int n = string.indexOf(95);
        if (n < 0) {
            string4 = string;
            string3 = "";
            string2 = "";
        } else {
            int n2;
            string4 = string.substring(0, n);
            if ((n2 = string.indexOf(95, ++n)) < 0) {
                string3 = string.substring(n);
                string2 = "";
            } else {
                string3 = string.substring(n, n2);
                string2 = string.substring(n2 + 1);
            }
        }
        string4 = string4.length() == 2 ? string4.toLowerCase(Locale.US) : "";
        string3 = string3.length() == 2 ? string3.toUpperCase(Locale.US) : "";
        string2 = string2.length() > 0 && (string4.length() == 2 || string3.length() == 2) ? string2.toUpperCase(Locale.US) : "";
        return LocaleCache.getInstance().getLocale(string4, string3, string2);
    }

    @Nullable
    public static Locale getLocaleToUseOrNull(@Nonnull Locale locale, @Nonnull Collection<Locale> collection) {
        return LocaleHelper.getLocaleToUseOrFallback(locale, collection, null);
    }

    @Nullable
    public static Locale getLocaleToUseOrFallback(@Nonnull Locale locale, @Nonnull Collection<Locale> collection, @Nullable Locale locale2) {
        ValueEnforcer.notNull((Object)locale, (String)"RequestLocale");
        ValueEnforcer.notNull(collection, (String)"AvailableLocales");
        if (collection.contains(locale)) {
            return locale;
        }
        for (Locale object : LocaleHelper.getCalculatedLocaleListForResolving(locale)) {
            if (!collection.contains(object)) continue;
            return object;
        }
        String string = locale.getLanguage();
        if (string != null) {
            for (Locale locale3 : collection) {
                if (!string.equals(locale3.getLanguage())) continue;
                return locale3;
            }
        }
        if (collection.contains(LOCALE_ALL)) {
            return LOCALE_ALL;
        }
        if (collection.contains(LOCALE_INDEPENDENT)) {
            return LOCALE_INDEPENDENT;
        }
        return locale2;
    }

    public static boolean isSpecialLocale(@Nullable Locale locale) {
        return LOCALE_ALL.equals(locale) || LOCALE_INDEPENDENT.equals(locale);
    }

    public static boolean isSpecialLocaleCode(@Nullable String string) {
        return LOCALE_ALL_STR.equalsIgnoreCase(string) || LOCALE_INDEPENDENT_STR.equalsIgnoreCase(string);
    }

    @Nullable
    public static String getValidLanguageCode(@Nullable String string) {
        if (StringHelper.isNotEmpty((String)string) && (RegExHelper.stringMatchesPattern((String)"[a-zA-Z]{2,8}", (String)string) || LocaleHelper.isSpecialLocaleCode(string))) {
            return string.toLowerCase(Locale.ROOT);
        }
        return null;
    }

    @Nullable
    public static String getValidCountryCode(@Nullable String string) {
        if (StringHelper.isNotEmpty((String)string)) {
            if (RegExHelper.stringMatchesPattern((String)"[a-zA-Z]{2}|[0-9][a-zA-Z]|[0-9]{3}", (String)string)) {
                return string.toUpperCase(Locale.ROOT);
            }
            if (RegExHelper.stringMatchesPattern((String)"[a-zA-Z]{3}", (String)string)) {
                String string2 = string.toUpperCase(Locale.ROOT);
                String string3 = (String)COUNTRY_ISO3TO2.get((Object)string2);
                return string3 != null ? string3 : string2;
            }
        }
        return null;
    }

    @Nonnull
    public static EChange clearCache() {
        return LOCALE_LIST_CACHE.clearCache();
    }

    static {
        COUNTRY_ISO3TO2 = new CommonsHashMap();
        INSTANCE = new LocaleHelper();
        LOCALE_LIST_CACHE = Cache.builder().valueProvider(locale -> {
            ValueEnforcer.notNull((Object)locale, (String)"BaseLocale");
            CommonsArrayList commonsArrayList = new CommonsArrayList(3);
            String string = locale.getLanguage();
            if (string.length() > 0) {
                LocaleCache localeCache = LocaleCache.getInstance();
                commonsArrayList.add(0, (Object)localeCache.getLocale(string));
                String string2 = locale.getCountry();
                if (string2.length() > 0) {
                    commonsArrayList.add(0, (Object)localeCache.getLocale(string, string2));
                    String string3 = locale.getVariant();
                    if (string3.length() > 0) {
                        commonsArrayList.add(0, (Object)localeCache.getLocale(string, string2, string3));
                    }
                }
            }
            return commonsArrayList.getAsUnmodifiable();
        }).name(LocaleHelper.class.getName() + "$Cache").build();
        for (String string : Locale.getISOCountries()) {
            Locale locale2 = new Locale("", string);
            COUNTRY_ISO3TO2.put((Object)locale2.getISO3Country(), (Object)locale2.getCountry());
        }
    }
}

