/*
 * Decompiled with CFR 0.152.
 */
package com.helger.settings.exchange.configfile;

import com.helger.annotation.Nonempty;
import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.annotation.style.ReturnsImmutableObject;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.builder.IBuilder;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.string.StringHelper;
import com.helger.base.system.SystemProperties;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.collection.commons.CommonsArrayList;
import com.helger.collection.commons.ICommonsIterable;
import com.helger.collection.commons.ICommonsList;
import com.helger.io.resource.IReadableResource;
import com.helger.io.resourceprovider.DefaultResourceProvider;
import com.helger.io.resourceprovider.IReadableResourceProvider;
import com.helger.settings.ISettings;
import com.helger.settings.exchange.ISettingsPersistence;
import com.helger.settings.exchange.configfile.ConfigFile;
import com.helger.settings.exchange.configfile.TrimmedValueSettings;
import com.helger.settings.exchange.properties.SettingsPersistenceProperties;
import java.io.InputStream;
import java.util.Iterator;
import java.util.function.Supplier;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class ConfigFileBuilder
implements IBuilder<ConfigFile> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigFileBuilder.class);
    private ISettingsPersistence m_aSPP = new SettingsPersistenceProperties(TrimmedValueSettings::new);
    private IReadableResourceProvider m_aResProvider = new DefaultResourceProvider();
    private final ICommonsList<String> m_aPaths = new CommonsArrayList();

    public @NonNull ConfigFileBuilder settingsPersistence(@NonNull ISettingsPersistence iSettingsPersistence) {
        ValueEnforcer.notNull((Object)iSettingsPersistence, (String)"SPP");
        this.m_aSPP = iSettingsPersistence;
        return this;
    }

    public @NonNull ISettingsPersistence settingsPersistence() {
        return this.m_aSPP;
    }

    public @NonNull ConfigFileBuilder resourceProvider(@NonNull IReadableResourceProvider iReadableResourceProvider) {
        ValueEnforcer.notNull((Object)iReadableResourceProvider, (String)"ResProvider");
        this.m_aResProvider = iReadableResourceProvider;
        return this;
    }

    public @NonNull IReadableResourceProvider resourceProvider() {
        return this.m_aResProvider;
    }

    public @NonNull ConfigFileBuilder addPathFromSystemProperty(@NonNull @Nonempty String string) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"SystemPropertyName");
        return this.addPath(() -> SystemProperties.getPropertyValueOrNull((String)string));
    }

    public @NonNull ConfigFileBuilder addPathFromEnvVar(@NonNull @Nonempty String string) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"EnvVarName");
        return this.addPath(() -> System.getenv().get(string));
    }

    public @NonNull ConfigFileBuilder addPath(@NonNull Supplier<? extends String> supplier) {
        ValueEnforcer.notNull(supplier, (String)"Supplier");
        return this.addPath(supplier.get());
    }

    public @NonNull ConfigFileBuilder addPath(@Nullable String string) {
        if (StringHelper.isNotEmpty((String)string)) {
            this.m_aPaths.add((Object)string);
        }
        return this;
    }

    public @NonNull ConfigFileBuilder addPaths(String ... stringArray) {
        ValueEnforcer.notNullNoNullValue((Object[])stringArray, (String)"ConfigPaths");
        for (String string : stringArray) {
            this.addPath(string);
        }
        return this;
    }

    public @NonNull ConfigFileBuilder addPaths(@NonNull Iterable<String> iterable) {
        ValueEnforcer.notNullNoNullValue(iterable, (String)"ConfigPaths");
        for (String string : iterable) {
            this.addPath(string);
        }
        return this;
    }

    public @NonNull ConfigFileBuilder path(@NonNull @Nonempty String string) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"ConfigPath");
        this.m_aPaths.set((Object)string);
        return this;
    }

    public @NonNull ConfigFileBuilder paths(String ... stringArray) {
        ValueEnforcer.notEmptyNoNullValue((Object[])stringArray, (String)"ConfigPaths");
        this.m_aPaths.setAll((Object[])stringArray);
        return this;
    }

    public @NonNull ConfigFileBuilder paths(@NonNull @Nonempty Iterable<String> iterable) {
        ValueEnforcer.notEmptyNoNullValue(iterable, (String)"ConfigPaths");
        this.m_aPaths.setAll(iterable);
        return this;
    }

    @ReturnsMutableCopy
    public @NonNull ICommonsList<String> getAllPaths() {
        return (ICommonsList)this.m_aPaths.getClone();
    }

    @ReturnsImmutableObject
    public @NonNull ICommonsIterable<String> paths() {
        return this.m_aPaths;
    }

    public @NonNull ConfigFile build() {
        InputStream inputStream;
        String string;
        if (this.m_aPaths.isEmpty()) {
            throw new IllegalStateException("No config file path was provided!");
        }
        IReadableResource iReadableResource = null;
        ISettings iSettings = null;
        Iterator iterator = this.m_aPaths.iterator();
        while (iterator.hasNext() && (!this.m_aResProvider.supportsReading(string = (String)iterator.next()) || (iReadableResource = this.m_aResProvider.getReadableResource(string)) == null || (inputStream = iReadableResource.getInputStream()) == null || (iSettings = this.m_aSPP.readSettings(inputStream)) == null)) {
        }
        if (iSettings == null) {
            LOGGER.warn("Failed to resolve config file paths: " + String.valueOf(this.m_aPaths));
        }
        return new ConfigFile(iSettings != null ? iReadableResource : null, iSettings);
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("SettingsPersistencyProvider", (Object)this.m_aSPP).append("ResourceProvider", (Object)this.m_aResProvider).append("Paths", this.m_aPaths).getToString();
    }
}

