/*
 * Decompiled with CFR 0.152.
 */
package com.helger.settings;

import com.helger.annotation.Nonempty;
import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.equals.EqualsHelper;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.state.EChange;
import com.helger.base.state.IChangeIndicator;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.settings.ISettings;
import com.helger.settings.ISettingsWithDefault;
import com.helger.settings.Settings;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@NotThreadSafe
public class SettingsWithDefault
extends Settings
implements ISettingsWithDefault {
    private final transient ISettings m_aDefaultSettings;

    public SettingsWithDefault(@NonNull ISettings iSettings) {
        this(iSettings.getName(), iSettings);
    }

    public SettingsWithDefault(@NonNull @Nonempty String string, @NonNull ISettings iSettings) {
        super(string);
        this.m_aDefaultSettings = (ISettings)ValueEnforcer.notNull((Object)iSettings, (String)"DefaultSettings");
    }

    @Override
    public boolean containsKeyDirect(@Nullable String string) {
        return super.containsKey((Object)string);
    }

    public boolean containsKey(@Nullable Object object) {
        if (this.containsKeyDirect((String)object)) {
            return true;
        }
        return this.m_aDefaultSettings.containsKey(object);
    }

    @Override
    public @Nullable Object getValueDirect(@Nullable String string) {
        return super.getValue((Object)string);
    }

    public @Nullable Object getValue(@Nullable String string) {
        Object object = this.getValueDirect(string);
        if (object == null) {
            object = this.m_aDefaultSettings.getValue(string);
        }
        return object;
    }

    @Override
    public final @NonNull ISettings getDefaultSettings() {
        return this.m_aDefaultSettings;
    }

    @Override
    public @NonNull EChange setToDefault(@Nullable String string) {
        Object object = this.m_aDefaultSettings.getValue(string);
        if (object == null) {
            return EChange.UNCHANGED;
        }
        return this.putIn(string, object);
    }

    @Override
    public final @NonNull EChange setAllToDefault() {
        EChange eChange = EChange.UNCHANGED;
        for (String string : this.m_aDefaultSettings.keySet()) {
            eChange = eChange.or((IChangeIndicator)this.setToDefault(string));
        }
        return eChange;
    }

    @Override
    public final boolean isSetToDefault(@Nullable String string) {
        return this.containsKeyDirect(string) && EqualsHelper.equals((Object)this.getValueDirect(string), (Object)this.m_aDefaultSettings.getValue(string));
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        SettingsWithDefault settingsWithDefault = (SettingsWithDefault)object;
        return this.m_aDefaultSettings.equals(settingsWithDefault.m_aDefaultSettings);
    }

    @Override
    public int hashCode() {
        return HashCodeGenerator.getDerived((int)super.hashCode()).append((Object)this.m_aDefaultSettings).getHashCode();
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived((String)super.toString()).append("DefaultSettings", (Object)this.m_aDefaultSettings).getToString();
    }
}

