/*
 * Decompiled with CFR 0.152.
 */
package com.helger.settings.exchange.xml;

import com.helger.annotation.Nonempty;
import com.helger.annotation.WillClose;
import com.helger.annotation.style.OverrideOnDemand;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.io.stream.StreamHelper;
import com.helger.base.reflection.GenericReflection;
import com.helger.base.state.ESuccess;
import com.helger.settings.ISettings;
import com.helger.settings.Settings;
import com.helger.settings.exchange.ISettingsPersistence;
import com.helger.settings.exchange.xml.SettingsMicroDocumentConverter;
import com.helger.settings.factory.ISettingsFactory;
import com.helger.xml.microdom.IMicroDocument;
import com.helger.xml.microdom.IMicroNode;
import com.helger.xml.microdom.MicroDocument;
import com.helger.xml.microdom.serialize.MicroReader;
import com.helger.xml.microdom.serialize.MicroWriter;
import com.helger.xml.serialize.write.IXMLWriterSettings;
import com.helger.xml.serialize.write.XMLWriterSettings;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public class SettingsPersistenceXML<T extends ISettings>
implements ISettingsPersistence {
    public static final boolean DEFAULT_MARSHAL_TYPES = true;
    private final ISettingsFactory<T> m_aSettingsFactory;
    private final IXMLWriterSettings m_aXWS;

    public SettingsPersistenceXML(@NonNull ISettingsFactory<T> iSettingsFactory) {
        this(iSettingsFactory, XMLWriterSettings.DEFAULT_XML_SETTINGS);
    }

    public SettingsPersistenceXML(@NonNull ISettingsFactory<T> iSettingsFactory, @NonNull IXMLWriterSettings iXMLWriterSettings) {
        this.m_aSettingsFactory = (ISettingsFactory)ValueEnforcer.notNull(iSettingsFactory, (String)"SettingsFactory");
        this.m_aXWS = iXMLWriterSettings;
    }

    @Override
    public final @NonNull Charset getCharset() {
        return this.m_aXWS.getCharset();
    }

    public final @NonNull ISettingsFactory<T> getSettingsFactory() {
        return this.m_aSettingsFactory;
    }

    public final @NonNull IXMLWriterSettings getXMLWriterSettings() {
        return this.m_aXWS;
    }

    public @NonNull T readSettings(@WillClose @NonNull InputStream inputStream) {
        ValueEnforcer.notNull((Object)inputStream, (String)"InputStream");
        IMicroDocument iMicroDocument = MicroReader.readMicroXML((InputStream)inputStream);
        if (iMicroDocument == null) {
            throw new IllegalArgumentException("Passed XML document is illegal");
        }
        SettingsMicroDocumentConverter<T> settingsMicroDocumentConverter = new SettingsMicroDocumentConverter<T>(this.m_aSettingsFactory);
        return (T)settingsMicroDocumentConverter.convertToNative(iMicroDocument.getDocumentElement());
    }

    @OverrideOnDemand
    protected @Nullable String getWriteNamespaceURI() {
        return null;
    }

    @Nonempty
    @OverrideOnDemand
    protected @NonNull @Nonempty String getWriteElementName() {
        return "settings";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public @NonNull ESuccess writeSettings(@NonNull ISettings iSettings, @WillClose @NonNull OutputStream outputStream) {
        ValueEnforcer.notNull((Object)iSettings, (String)"Settings");
        ValueEnforcer.notNull((Object)outputStream, (String)"OutputStream");
        try {
            ValueEnforcer.notNull((Object)iSettings, (String)"Settings");
            SettingsMicroDocumentConverter<ISettings> settingsMicroDocumentConverter = new SettingsMicroDocumentConverter<ISettings>(this.m_aSettingsFactory);
            MicroDocument microDocument = new MicroDocument();
            microDocument.addChild((IMicroNode)settingsMicroDocumentConverter.convertToMicroElement((ISettings)GenericReflection.uncheckedCast((Object)iSettings), this.getWriteNamespaceURI(), this.getWriteElementName()));
            ESuccess eSuccess = MicroWriter.writeToStream((IMicroNode)microDocument, (OutputStream)outputStream, (IXMLWriterSettings)this.m_aXWS);
            return eSuccess;
        }
        finally {
            StreamHelper.close((AutoCloseable)outputStream);
        }
    }

    public static @NonNull SettingsPersistenceXML<Settings> createDefault() {
        return new SettingsPersistenceXML<Settings>(ISettingsFactory.newInstance());
    }
}

