/*
 * Decompiled with CFR 0.152.
 */
package com.helger.settings.exchange.properties;

import com.helger.annotation.Nonempty;
import com.helger.annotation.WillClose;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.io.stream.StreamHelper;
import com.helger.base.rt.NonBlockingProperties;
import com.helger.base.rt.PropertiesHelper;
import com.helger.base.state.ESuccess;
import com.helger.settings.ISettings;
import com.helger.settings.exchange.ISettingsPersistence;
import com.helger.settings.factory.ISettingsFactory;
import com.helger.typeconvert.impl.TypeConverter;
import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SettingsPersistenceProperties
implements ISettingsPersistence {
    public static final Charset DEFAULT_CHARSET = StandardCharsets.ISO_8859_1;
    private static final Logger LOGGER = LoggerFactory.getLogger(SettingsPersistenceProperties.class);
    private final ISettingsFactory<?> m_aSettingsFactory;
    private Charset m_aCharset = DEFAULT_CHARSET;

    public SettingsPersistenceProperties() {
        this(ISettingsFactory.newInstance());
    }

    public SettingsPersistenceProperties(@Nonnull ISettingsFactory<?> iSettingsFactory) {
        this.m_aSettingsFactory = (ISettingsFactory)ValueEnforcer.notNull(iSettingsFactory, (String)"SettingsFactory");
    }

    @Override
    @Nonnull
    public final Charset getCharset() {
        return this.m_aCharset;
    }

    @Nonnull
    public final SettingsPersistenceProperties setCharset(@Nonnull Charset charset) {
        ValueEnforcer.notNull((Object)charset, (String)"Charset");
        this.m_aCharset = charset;
        return this;
    }

    @Nonnull
    public final ISettingsFactory<?> getSettingsFactory() {
        return this.m_aSettingsFactory;
    }

    @Nonnull
    @Nonempty
    protected String getReadSettingsName() {
        return "anonymous";
    }

    @Override
    @Nonnull
    public ISettings readSettings(@Nonnull @WillClose InputStream inputStream) {
        ValueEnforcer.notNull((Object)inputStream, (String)"InputStream");
        Object obj = this.m_aSettingsFactory.apply(this.getReadSettingsName());
        NonBlockingProperties nonBlockingProperties = PropertiesHelper.loadProperties((InputStream)inputStream);
        if (nonBlockingProperties != null) {
            for (Map.Entry entry : nonBlockingProperties.entrySet()) {
                obj.putIn((Object)((String)entry.getKey()), entry.getValue());
            }
        }
        return obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public ESuccess writeSettings(@Nonnull ISettings iSettings, @Nonnull @WillClose OutputStream outputStream) {
        ValueEnforcer.notNull((Object)outputStream, (String)"OutputStream");
        try {
            NonBlockingProperties nonBlockingProperties = new NonBlockingProperties();
            for (Map.Entry entry : iSettings.entrySet()) {
                String string = (String)entry.getKey();
                Object v = entry.getValue();
                if (v instanceof ISettings) {
                    throw new IllegalArgumentException("When saving settings to a Properties object, it may not contained nested settings! Now the key '" + string + "' is mapped to a nested ISettings object!");
                }
                String string2 = (String)TypeConverter.convert(v, String.class);
                nonBlockingProperties.put((Object)string, (Object)string2);
            }
            nonBlockingProperties.store(outputStream, iSettings.getName());
            ESuccess eSuccess = ESuccess.SUCCESS;
            return eSuccess;
        }
        catch (IOException iOException) {
            LOGGER.error("Failed to write settings to properties file", (Throwable)iOException);
            ESuccess eSuccess = ESuccess.FAILURE;
            return eSuccess;
        }
        finally {
            StreamHelper.close((AutoCloseable)outputStream);
        }
    }
}

