/*
 * Decompiled with CFR 0.152.
 */
package com.helger.settings.factory;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.settings.ISettings;
import com.helger.settings.Settings;
import com.helger.settings.SettingsWithDefault;
import java.util.function.Function;
import javax.annotation.Nonnull;

public interface ISettingsFactory<T extends ISettings>
extends Function<String, T> {
    @Override
    @Nonnull
    public T apply(@Nonnull @Nonempty String var1);

    @Nonnull
    public static ISettingsFactory<Settings> newInstance() {
        return Settings::new;
    }

    @Nonnull
    public static ISettingsFactory<SettingsWithDefault> newInstance(@Nonnull ISettings iSettings) {
        ValueEnforcer.notNull((Object)iSettings, (String)"DefaultSettings");
        return string -> new SettingsWithDefault(string, iSettings);
    }
}

