/*
 * Decompiled with CFR 0.152.
 */
package com.helger.security.crl;

import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.timing.StopWatch;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.base.url.IURLDownloader;
import com.helger.security.crl.CRLHelper;
import com.helger.url.protocol.EURLProtocol;
import java.security.cert.CRL;
import java.security.cert.X509CRL;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CRLDownloader {
    private static final Logger LOGGER = LoggerFactory.getLogger(CRLDownloader.class);
    private final IURLDownloader m_aURLDownloader;

    public CRLDownloader() {
        this(IURLDownloader.createDefault());
    }

    public CRLDownloader(@NonNull IURLDownloader iURLDownloader) {
        ValueEnforcer.notNull((Object)iURLDownloader, (String)"UrlDownloader");
        this.m_aURLDownloader = iURLDownloader;
    }

    public final @NonNull IURLDownloader getURLDownloader() {
        return this.m_aURLDownloader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public @Nullable CRL downloadCRL(@NonNull String string) {
        if (EURLProtocol.HTTP.isUsedInURL(string) || EURLProtocol.HTTPS.isUsedInURL(string)) {
            LOGGER.info("Downloading CRL from URL '" + string + "'");
            StopWatch stopWatch = StopWatch.createdStarted();
            int n = 0;
            try {
                byte[] byArray = this.getURLDownloader().downloadURL(string);
                if (byArray != null) {
                    n = byArray.length;
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("Finished downloading CRL and received " + n + " bytes");
                    }
                    X509CRL x509CRL = CRLHelper.convertToCRL(byArray);
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("Downloaded CRL is of type '" + x509CRL.getType() + "'");
                    }
                    X509CRL x509CRL2 = x509CRL;
                    return x509CRL2;
                }
                LOGGER.error("Failed to download CRL from URL '" + string + "' - null array returned");
            }
            catch (Exception exception) {
                LOGGER.error("Error downloading CRL from URL '" + string + "'", (Throwable)exception);
            }
            finally {
                stopWatch.stop();
                if (stopWatch.getMillis() > 1000L) {
                    LOGGER.info("Downloading the CRL from '" + string + "' took " + stopWatch.getMillis() + " milliseconds for " + n + " bytes");
                }
            }
        }
        return null;
    }

    public String toString() {
        return new ToStringGenerator(null).append("URLDownloader", (Object)this.m_aURLDownloader).getToString();
    }
}

