/*
 * Decompiled with CFR 0.152.
 */
package com.helger.security.authentication.credentials;

import com.helger.annotation.concurrent.Immutable;
import com.helger.annotation.style.CodingStyleguideUnaware;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.exception.InitializationException;
import com.helger.base.spi.ServiceLoaderHelper;
import com.helger.collection.commons.CommonsArrayList;
import com.helger.collection.commons.ICommonsList;
import com.helger.security.authentication.credentials.CredentialValidationResult;
import com.helger.security.authentication.credentials.CredentialValidationResultList;
import com.helger.security.authentication.credentials.IAuthCredentialValidatorSPI;
import com.helger.security.authentication.credentials.IAuthCredentials;
import com.helger.security.authentication.credentials.ICredentialValidationResult;
import java.util.List;
import org.jspecify.annotations.NonNull;

@Immutable
public final class AuthCredentialValidatorManager {
    @CodingStyleguideUnaware
    private static final List<IAuthCredentialValidatorSPI> HDL_LIST = ServiceLoaderHelper.getAllSPIImplementations(IAuthCredentialValidatorSPI.class);

    private AuthCredentialValidatorManager() {
    }

    @ReturnsMutableCopy
    public static @NonNull ICommonsList<IAuthCredentialValidatorSPI> getAllAuthCredentialValidators() {
        return new CommonsArrayList(HDL_LIST);
    }

    public static @NonNull ICredentialValidationResult validateCredentials(@NonNull IAuthCredentials iAuthCredentials) {
        ValueEnforcer.notNull((Object)iAuthCredentials, (String)"Credentials");
        CommonsArrayList commonsArrayList = new CommonsArrayList();
        for (IAuthCredentialValidatorSPI iAuthCredentialValidatorSPI : HDL_LIST) {
            if (!iAuthCredentialValidatorSPI.supportsCredentials(iAuthCredentials)) continue;
            ICredentialValidationResult iCredentialValidationResult = iAuthCredentialValidatorSPI.validateCredentials(iAuthCredentials);
            if (iCredentialValidationResult == null) {
                throw new IllegalStateException("validateCredentials returned a null object from " + String.valueOf(iAuthCredentialValidatorSPI) + " for credentials " + String.valueOf(iAuthCredentials));
            }
            if (iCredentialValidationResult.isSuccess()) {
                return iCredentialValidationResult;
            }
            commonsArrayList.add((Object)iCredentialValidationResult);
        }
        if (commonsArrayList.isEmpty()) {
            commonsArrayList.add((Object)new CredentialValidationResult("No credential validator supported the provided credentials: " + String.valueOf(iAuthCredentials)));
        }
        return new CredentialValidationResultList((Iterable<? extends ICredentialValidationResult>)commonsArrayList);
    }

    static {
        if (HDL_LIST.isEmpty()) {
            throw new InitializationException("No class implementing " + String.valueOf(IAuthCredentialValidatorSPI.class) + " was found!");
        }
    }
}

