/*
 * Decompiled with CFR 0.152.
 */
package com.helger.security.keystore;

import com.helger.annotation.concurrent.GuardedBy;
import com.helger.annotation.concurrent.ThreadSafe;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.concurrent.SimpleReadWriteLock;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.functional.IThrowingConsumer;
import com.helger.base.io.stream.StreamHelper;
import com.helger.base.lang.clazz.ClassHelper;
import com.helger.base.string.StringHelper;
import com.helger.collection.commons.CommonsHashSet;
import com.helger.collection.commons.ICommonsSet;
import com.helger.io.resourceprovider.ClassPathResourceProvider;
import com.helger.io.resourceprovider.FileSystemResourceProvider;
import com.helger.io.resourceprovider.IReadableResourceProvider;
import com.helger.io.resourceprovider.ReadableResourceProviderChain;
import com.helger.security.keystore.EKeyStoreLoadError;
import com.helger.security.keystore.IKeyStoreType;
import com.helger.security.keystore.LoadedKey;
import com.helger.security.keystore.LoadedKeyStore;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.Provider;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class KeyStoreHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(KeyStoreHelper.class);
    private static final SimpleReadWriteLock RW_LOCK = new SimpleReadWriteLock();
    @GuardedBy(value="RW_LOCK")
    private static IReadableResourceProvider s_aResourceProvider = new ReadableResourceProviderChain(new IReadableResourceProvider[]{new FileSystemResourceProvider().setCanReadRelativePaths(true), new ClassPathResourceProvider()});
    private static final KeyStoreHelper INSTANCE = new KeyStoreHelper();

    private KeyStoreHelper() {
    }

    public static @NonNull IReadableResourceProvider getResourceProvider() {
        return (IReadableResourceProvider)RW_LOCK.readLockedGet(() -> s_aResourceProvider);
    }

    public static void setResourceProvider(@NonNull IReadableResourceProvider iReadableResourceProvider) {
        ValueEnforcer.notNull((Object)iReadableResourceProvider, (String)"ResourceProvider");
        RW_LOCK.writeLocked(() -> {
            s_aResourceProvider = iReadableResourceProvider;
        });
    }

    public static @NonNull KeyStore getSimiliarKeyStore(@NonNull KeyStore keyStore) throws KeyStoreException {
        ValueEnforcer.notNull((Object)keyStore, (String)"Other");
        return KeyStoreHelper.getSimiliarKeyStore(keyStore, null);
    }

    public static @NonNull KeyStore getSimiliarKeyStore(@NonNull KeyStore keyStore, @Nullable Provider provider) throws KeyStoreException {
        ValueEnforcer.notNull((Object)keyStore, (String)"Other");
        return KeyStore.getInstance(keyStore.getType(), provider != null ? provider : keyStore.getProvider());
    }

    public static @NonNull KeyStore loadKeyStoreDirect(@NonNull IKeyStoreType iKeyStoreType, @Nullable String string, char @Nullable [] cArray) throws GeneralSecurityException, IOException {
        return KeyStoreHelper.loadKeyStoreDirect(iKeyStoreType, string, cArray, null);
    }

    public static @NonNull KeyStore loadKeyStoreDirect(@NonNull IKeyStoreType iKeyStoreType, @Nullable String string, char @Nullable [] cArray, @Nullable Provider provider) throws GeneralSecurityException, IOException {
        KeyStore keyStore;
        InputStream inputStream;
        ValueEnforcer.notNull((Object)iKeyStoreType, (String)"KeyStoreType");
        if (iKeyStoreType.isKeyStorePathRequired()) {
            ValueEnforcer.notNull((Object)string, (String)"KeyStorePath");
            inputStream = KeyStoreHelper.getResourceProvider().getInputStream(string);
            if (inputStream == null) {
                throw new IllegalArgumentException("Failed to open key store '" + string + "'");
            }
        } else {
            inputStream = null;
        }
        try {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Trying to load key store from path '" + string + "' using type " + (String)iKeyStoreType.getID());
            }
            KeyStore keyStore2 = provider != null ? iKeyStoreType.getKeyStore(provider) : iKeyStoreType.getKeyStore();
            keyStore2.load(inputStream, cArray);
            keyStore = keyStore2;
        }
        catch (KeyStoreException keyStoreException) {
            try {
                throw new IllegalStateException("No provider can handle key stores of type " + String.valueOf(iKeyStoreType), keyStoreException);
            }
            catch (Throwable throwable) {
                StreamHelper.close(inputStream);
                throw throwable;
            }
        }
        StreamHelper.close((AutoCloseable)inputStream);
        return keyStore;
    }

    public static @NonNull KeyStore createKeyStoreWithOnlyOneItem(@NonNull KeyStore keyStore, @NonNull String string, char @Nullable [] cArray) throws GeneralSecurityException, IOException {
        return KeyStoreHelper.createKeyStoreWithOnlyOneItem(keyStore, string, cArray, null);
    }

    public static @NonNull KeyStore createKeyStoreWithOnlyOneItem(@NonNull KeyStore keyStore, @NonNull String string, char @Nullable [] cArray, @Nullable Provider provider) throws GeneralSecurityException, IOException {
        ValueEnforcer.notNull((Object)keyStore, (String)"BaseKeyStore");
        ValueEnforcer.notNull((Object)string, (String)"AliasToCopy");
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Create a new key store using type " + keyStore.getType());
        }
        KeyStore keyStore2 = KeyStoreHelper.getSimiliarKeyStore(keyStore, provider);
        keyStore2.load(null, null);
        KeyStore.PasswordProtection passwordProtection = null;
        if (cArray != null) {
            passwordProtection = new KeyStore.PasswordProtection(cArray);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Copying alias '" + string + "' from old key store to new key store");
        }
        keyStore2.setEntry(string, keyStore.getEntry(string, passwordProtection), passwordProtection);
        return keyStore2;
    }

    private static boolean _isInvalidPasswordException(@NonNull Exception exception) {
        return exception instanceof IOException && exception.getCause() instanceof UnrecoverableKeyException;
    }

    public static @NonNull LoadedKeyStore loadKeyStore(@NonNull IKeyStoreType iKeyStoreType, @Nullable String string, char @Nullable [] cArray) {
        return KeyStoreHelper.loadKeyStore(iKeyStoreType, string, cArray, null);
    }

    public static @NonNull LoadedKeyStore loadKeyStore(@NonNull IKeyStoreType iKeyStoreType, @Nullable String string, char @Nullable [] cArray, @Nullable Provider provider) {
        KeyStore keyStore;
        ValueEnforcer.notNull((Object)iKeyStoreType, (String)"KeyStoreType");
        if (iKeyStoreType.isKeyStorePathRequired() && StringHelper.isEmpty((String)string)) {
            return new LoadedKeyStore(null, EKeyStoreLoadError.KEYSTORE_NO_PATH, new String[0]);
        }
        try {
            keyStore = KeyStoreHelper.loadKeyStoreDirect(iKeyStoreType, string, cArray, provider);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            LOGGER.warn("No such key store '" + string + "': " + illegalArgumentException.getMessage(), illegalArgumentException.getCause());
            return new LoadedKeyStore(null, EKeyStoreLoadError.KEYSTORE_LOAD_ERROR_NON_EXISTING, string, illegalArgumentException.getMessage());
        }
        catch (Exception exception) {
            boolean bl = KeyStoreHelper._isInvalidPasswordException(exception);
            LOGGER.warn("Failed to load key store '" + string + "' of type " + (String)iKeyStoreType.getID() + ": " + exception.getMessage(), bl ? null : exception.getCause());
            return new LoadedKeyStore(null, bl ? EKeyStoreLoadError.KEYSTORE_INVALID_PASSWORD : EKeyStoreLoadError.KEYSTORE_LOAD_ERROR_FORMAT_ERROR, string, exception.getMessage());
        }
        return new LoadedKeyStore(keyStore, null, new String[0]);
    }

    private static <T extends KeyStore.Entry> @NonNull LoadedKey<T> _loadKey(@NonNull KeyStore keyStore, @NonNull String string, @Nullable String string2, char @Nullable [] cArray, @NonNull Class<T> clazz) {
        KeyStore.Entry entry;
        ValueEnforcer.notNull((Object)keyStore, (String)"KeyStore");
        ValueEnforcer.notNull((Object)string, (String)"KeyStorePath");
        ValueEnforcer.notNull(clazz, (String)"TargetClass");
        if (StringHelper.isEmpty((String)string2)) {
            return new LoadedKey<Object>(null, EKeyStoreLoadError.KEY_NO_ALIAS, string);
        }
        if (cArray == null) {
            return new LoadedKey<Object>(null, EKeyStoreLoadError.KEY_NO_PASSWORD, string2, string);
        }
        try {
            KeyStore.PasswordProtection passwordProtection;
            KeyStore.Entry entry2;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Trying to access key store entry with alias '" + string2 + "' as a " + clazz.getName());
            }
            if ((entry2 = keyStore.getEntry(string2, passwordProtection = new KeyStore.PasswordProtection(cArray))) == null) {
                return new LoadedKey<Object>(null, EKeyStoreLoadError.KEY_INVALID_ALIAS, string2, string);
            }
            if (!clazz.isAssignableFrom(entry2.getClass())) {
                return new LoadedKey<Object>(null, EKeyStoreLoadError.KEY_INVALID_TYPE, string2, string, ClassHelper.getClassName((Object)entry2));
            }
            entry = (KeyStore.Entry)clazz.cast(entry2);
        }
        catch (UnrecoverableKeyException unrecoverableKeyException) {
            return new LoadedKey<Object>(null, EKeyStoreLoadError.KEY_INVALID_PASSWORD, string2, string, unrecoverableKeyException.getMessage());
        }
        catch (GeneralSecurityException generalSecurityException) {
            return new LoadedKey<Object>(null, EKeyStoreLoadError.KEY_LOAD_ERROR, string2, string, generalSecurityException.getMessage());
        }
        return new LoadedKey<KeyStore.Entry>(entry, null, new String[0]);
    }

    public static @NonNull LoadedKey<KeyStore.PrivateKeyEntry> loadPrivateKey(@NonNull KeyStore keyStore, @NonNull String string, @Nullable String string2, char @Nullable [] cArray) {
        return KeyStoreHelper._loadKey(keyStore, string, string2, cArray, KeyStore.PrivateKeyEntry.class);
    }

    public static @NonNull LoadedKey<KeyStore.SecretKeyEntry> loadSecretKey(@NonNull KeyStore keyStore, @NonNull String string, @Nullable String string2, char @Nullable [] cArray) {
        return KeyStoreHelper._loadKey(keyStore, string, string2, cArray, KeyStore.SecretKeyEntry.class);
    }

    public static @NonNull LoadedKey<KeyStore.TrustedCertificateEntry> loadTrustedCertificateKey(@NonNull KeyStore keyStore, @NonNull String string, @Nullable String string2, char @Nullable [] cArray) {
        return KeyStoreHelper._loadKey(keyStore, string, string2, cArray, KeyStore.TrustedCertificateEntry.class);
    }

    public static void iterateKeyStore(@NonNull KeyStore keyStore, @NonNull IThrowingConsumer<String, KeyStoreException> iThrowingConsumer) {
        ValueEnforcer.notNull((Object)keyStore, (String)"KeyStore");
        ValueEnforcer.notNull(iThrowingConsumer, (String)"AliasConsumer");
        try {
            Enumeration<String> enumeration = keyStore.aliases();
            while (enumeration.hasMoreElements()) {
                String string = enumeration.nextElement();
                iThrowingConsumer.accept((Object)string);
            }
        }
        catch (KeyStoreException keyStoreException) {
            LOGGER.warn("Failed to iterate key store", (Throwable)keyStoreException);
        }
    }

    @ReturnsMutableCopy
    public static @NonNull ICommonsSet<X509Certificate> getAllTrustedCertificates(@Nullable KeyStore keyStore) {
        CommonsHashSet commonsHashSet = new CommonsHashSet();
        if (keyStore != null) {
            KeyStoreHelper.iterateKeyStore(keyStore, (IThrowingConsumer<String, KeyStoreException>)((IThrowingConsumer)arg_0 -> KeyStoreHelper.lambda$getAllTrustedCertificates$2(keyStore, (ICommonsSet)commonsHashSet, arg_0)));
        }
        return commonsHashSet;
    }

    private static /* synthetic */ void lambda$getAllTrustedCertificates$2(KeyStore keyStore, ICommonsSet iCommonsSet, String string) throws KeyStoreException {
        Certificate certificate;
        if (keyStore.isCertificateEntry(string) && (certificate = keyStore.getCertificate(string)) instanceof X509Certificate) {
            X509Certificate x509Certificate = (X509Certificate)certificate;
            iCommonsSet.add((Object)x509Certificate);
        }
    }
}

