/*
 * Decompiled with CFR 0.152.
 */
package com.helger.security.keystore;

import com.helger.annotation.Nonempty;
import com.helger.annotation.style.ReturnsMutableObject;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.security.keystore.IKeyStoreAndKeyDescriptor;
import com.helger.security.keystore.IKeyStoreType;
import com.helger.security.keystore.KeyStoreAndKeyDescriptorBuilder;
import com.helger.security.keystore.KeyStoreHelper;
import com.helger.security.keystore.LoadedKey;
import com.helger.security.keystore.LoadedKeyStore;
import java.security.KeyStore;
import java.security.Provider;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public class KeyStoreAndKeyDescriptor
implements IKeyStoreAndKeyDescriptor {
    final IKeyStoreType m_aType;
    final String m_sPath;
    final char[] m_aPassword;
    final Provider m_aProvider;
    final String m_sKeyAlias;
    final char[] m_aKeyPassword;
    private LoadedKeyStore m_aLKS;
    private LoadedKey<KeyStore.PrivateKeyEntry> m_aLK;

    public KeyStoreAndKeyDescriptor(@NonNull IKeyStoreType iKeyStoreType, @NonNull @Nonempty String string, char @NonNull [] cArray, @Nullable Provider provider, @NonNull @Nonempty String string2, char @NonNull [] cArray2) {
        ValueEnforcer.notNull((Object)iKeyStoreType, (String)"Type");
        ValueEnforcer.notEmpty((CharSequence)string, (String)"Path");
        ValueEnforcer.notNull((Object)cArray, (String)"Password");
        ValueEnforcer.notEmpty((CharSequence)string2, (String)"KeyAlias");
        ValueEnforcer.notNull((Object)cArray2, (String)"KeyPassword");
        this.m_aType = iKeyStoreType;
        this.m_sPath = string;
        this.m_aPassword = cArray;
        this.m_aProvider = provider;
        this.m_sKeyAlias = string2;
        this.m_aKeyPassword = cArray2;
    }

    @Override
    public final @NonNull IKeyStoreType getKeyStoreType() {
        return this.m_aType;
    }

    @Override
    public final @NonNull @Nonempty String getKeyStorePath() {
        return this.m_sPath;
    }

    @Override
    @ReturnsMutableObject
    public final char @NonNull [] getKeyStorePassword() {
        return this.m_aPassword;
    }

    @Override
    public final @Nullable Provider getProvider() {
        return this.m_aProvider;
    }

    @Override
    public @NonNull LoadedKeyStore loadKeyStore() {
        LoadedKeyStore loadedKeyStore = this.m_aLKS;
        if (loadedKeyStore == null) {
            loadedKeyStore = this.m_aLKS = KeyStoreHelper.loadKeyStore(this.m_aType, this.m_sPath, this.m_aPassword, this.m_aProvider);
        }
        return loadedKeyStore;
    }

    @Override
    public final @NonNull @Nonempty String getKeyAlias() {
        return this.m_sKeyAlias;
    }

    @Override
    @ReturnsMutableObject
    public final char @NonNull [] getKeyPassword() {
        return this.m_aKeyPassword;
    }

    @Override
    public @NonNull LoadedKey<KeyStore.PrivateKeyEntry> loadKey() {
        LoadedKey<KeyStore.PrivateKeyEntry> loadedKey = this.m_aLK;
        if (loadedKey == null) {
            loadedKey = this.m_aLK = KeyStoreHelper.loadPrivateKey(this.loadKeyStore().getKeyStore(), this.m_sPath, this.m_sKeyAlias, this.m_aKeyPassword);
        }
        return loadedKey;
    }

    public String toString() {
        return new ToStringGenerator(null).append("Type", (Object)this.m_aType).append("Path", (Object)this.m_sPath).appendPassword("Password").appendIfNotNull("Provider", (Object)this.m_aProvider).append("KeyAlias", (Object)this.m_sKeyAlias).appendPassword("KeyPassword").getToString();
    }

    public static @NonNull KeyStoreAndKeyDescriptorBuilder builder() {
        return new KeyStoreAndKeyDescriptorBuilder();
    }

    public static @NonNull KeyStoreAndKeyDescriptorBuilder builder(@NonNull KeyStoreAndKeyDescriptor keyStoreAndKeyDescriptor) {
        return new KeyStoreAndKeyDescriptorBuilder(keyStoreAndKeyDescriptor);
    }
}

